/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionId;
import io.trino.metadata.Metadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class WindowFilterPushDown
implements PlanOptimizer {
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final DomainTranslator domainTranslator;

    public WindowFilterPushDown(Metadata metadata, TypeOperators typeOperators) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.domainTranslator = new DomainTranslator(metadata);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, this.metadata, this.typeOperators, this.domainTranslator, session, types), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final TypeOperators typeOperators;
        private final DomainTranslator domainTranslator;
        private final Session session;
        private final TypeProvider types;
        private final FunctionId rowNumberFunctionId;
        private final FunctionId rankFunctionId;

        private Rewriter(PlanNodeIdAllocator idAllocator, Metadata metadata, TypeOperators typeOperators, DomainTranslator domainTranslator, Session session, TypeProvider types) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.rowNumberFunctionId = metadata.resolveFunction(QualifiedName.of((String)"row_number"), (List<TypeSignatureProvider>)ImmutableList.of()).getFunctionId();
            this.rankFunctionId = metadata.resolveFunction(QualifiedName.of((String)"rank"), (List<TypeSignatureProvider>)ImmutableList.of()).getFunctionId();
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            if (this.canReplaceWithRowNumber(node)) {
                return new RowNumberNode(this.idAllocator.getNextId(), rewrittenSource, node.getPartitionBy(), false, (Symbol)Iterables.getOnlyElement(node.getWindowFunctions().keySet()), Optional.empty(), Optional.empty());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)rewrittenSource));
        }

        @Override
        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            WindowNode windowNode;
            Optional<TopNRankingNode.RankingType> rankingType;
            if (node.isWithTies()) {
                return context.defaultRewrite(node);
            }
            if (node.getCount() == 0L) {
                return node;
            }
            if (node.getCount() > Integer.MAX_VALUE) {
                return context.defaultRewrite(node);
            }
            PlanNode source = context.rewrite(node.getSource());
            int limit = Math.toIntExact(node.getCount());
            if (source instanceof RowNumberNode) {
                RowNumberNode rowNumberNode = Rewriter.mergeLimit((RowNumberNode)source, limit);
                if (rowNumberNode.getPartitionBy().isEmpty()) {
                    return rowNumberNode;
                }
                source = rowNumberNode;
            } else if (source instanceof WindowNode && SystemSessionProperties.isOptimizeTopNRanking(this.session) && (rankingType = this.toTopNRankingType(windowNode = (WindowNode)source)).isPresent()) {
                TopNRankingNode topNRankingNode = this.convertToTopNRanking(windowNode, rankingType.get(), limit);
                if (rankingType.get() == TopNRankingNode.RankingType.ROW_NUMBER && windowNode.getPartitionBy().isEmpty()) {
                    return topNRankingNode;
                }
                source = topNRankingNode;
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Symbol rankingSymbol;
            OptionalInt upperBound;
            WindowNode windowNode;
            Optional<TopNRankingNode.RankingType> rankingType;
            PlanNode source = context.rewrite(node.getSource());
            TupleDomain<Symbol> tupleDomain = DomainTranslator.fromPredicate(this.metadata, this.typeOperators, this.session, node.getPredicate(), this.types).getTupleDomain();
            if (source instanceof RowNumberNode) {
                Symbol rowNumberSymbol = ((RowNumberNode)source).getRowNumberSymbol();
                OptionalInt upperBound2 = Rewriter.extractUpperBound(tupleDomain, rowNumberSymbol);
                if (upperBound2.isPresent()) {
                    if (upperBound2.getAsInt() <= 0) {
                        return new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of());
                    }
                    source = Rewriter.mergeLimit((RowNumberNode)source, upperBound2.getAsInt());
                    return this.rewriteFilterSource(node, source, rowNumberSymbol, ((RowNumberNode)source).getMaxRowCountPerPartition().get());
                }
            } else if (source instanceof WindowNode && SystemSessionProperties.isOptimizeTopNRanking(this.session) && (rankingType = this.toTopNRankingType(windowNode = (WindowNode)source)).isPresent() && (upperBound = Rewriter.extractUpperBound(tupleDomain, rankingSymbol = (Symbol)((Map.Entry)Iterables.getOnlyElement(windowNode.getWindowFunctions().entrySet())).getKey())).isPresent()) {
                if (upperBound.getAsInt() <= 0) {
                    return new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of());
                }
                source = this.convertToTopNRanking(windowNode, rankingType.get(), upperBound.getAsInt());
                return this.rewriteFilterSource(node, source, rankingSymbol, upperBound.getAsInt());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        private PlanNode rewriteFilterSource(FilterNode filterNode, PlanNode source, Symbol rankingSymbol, int upperBound) {
            DomainTranslator.ExtractionResult extractionResult = DomainTranslator.fromPredicate(this.metadata, this.typeOperators, this.session, filterNode.getPredicate(), this.types);
            TupleDomain<Symbol> tupleDomain = extractionResult.getTupleDomain();
            if (!Rewriter.allRankingValuesInDomain(tupleDomain, rankingSymbol, upperBound)) {
                return new FilterNode(filterNode.getId(), source, filterNode.getPredicate());
            }
            TupleDomain newTupleDomain = tupleDomain.filter((symbol, domain) -> !symbol.equals(rankingSymbol));
            Expression newPredicate = ExpressionUtils.combineConjuncts(this.metadata, extractionResult.getRemainingExpression(), this.domainTranslator.toPredicate((TupleDomain<Symbol>)newTupleDomain));
            if (newPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return source;
            }
            return new FilterNode(filterNode.getId(), source, newPredicate);
        }

        private static boolean allRankingValuesInDomain(TupleDomain<Symbol> tupleDomain, Symbol symbol, long upperBound) {
            if (tupleDomain.isNone()) {
                return false;
            }
            Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
            if (domain == null) {
                return true;
            }
            return domain.getValues().contains(ValueSet.ofRanges((Range)Range.range((Type)domain.getType(), (Object)1L, (boolean)true, (Object)upperBound, (boolean)true), (Range[])new Range[0]));
        }

        private static OptionalInt extractUpperBound(TupleDomain<Symbol> tupleDomain, Symbol symbol) {
            if (tupleDomain.isNone()) {
                return OptionalInt.empty();
            }
            Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
            if (domain == null) {
                return OptionalInt.empty();
            }
            ValueSet values = domain.getValues();
            if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
                return OptionalInt.empty();
            }
            Range span = values.getRanges().getSpan();
            if (span.isHighUnbounded()) {
                return OptionalInt.empty();
            }
            Verify.verify((boolean)domain.getType().equals(BigintType.BIGINT));
            long upperBound = (Long)span.getHighBoundedValue();
            if (!span.isHighInclusive()) {
                --upperBound;
            }
            if (upperBound >= Integer.MIN_VALUE && upperBound <= Integer.MAX_VALUE) {
                return OptionalInt.of(Math.toIntExact(upperBound));
            }
            return OptionalInt.empty();
        }

        private static RowNumberNode mergeLimit(RowNumberNode node, int newRowCountPerPartition) {
            if (node.getMaxRowCountPerPartition().isPresent()) {
                newRowCountPerPartition = Math.min(node.getMaxRowCountPerPartition().get(), newRowCountPerPartition);
            }
            return new RowNumberNode(node.getId(), node.getSource(), node.getPartitionBy(), node.isOrderSensitive(), node.getRowNumberSymbol(), Optional.of(newRowCountPerPartition), node.getHashSymbol());
        }

        private TopNRankingNode convertToTopNRanking(WindowNode windowNode, TopNRankingNode.RankingType rankingType, int limit) {
            return new TopNRankingNode(this.idAllocator.getNextId(), windowNode.getSource(), windowNode.getSpecification(), rankingType, (Symbol)Iterables.getOnlyElement(windowNode.getWindowFunctions().keySet()), limit, false, Optional.empty());
        }

        private boolean canReplaceWithRowNumber(WindowNode node) {
            if (node.getWindowFunctions().size() != 1) {
                return false;
            }
            Symbol rankingSymbol = (Symbol)((Map.Entry)Iterables.getOnlyElement(node.getWindowFunctions().entrySet())).getKey();
            FunctionId functionId = node.getWindowFunctions().get(rankingSymbol).getResolvedFunction().getFunctionId();
            return functionId.equals(this.rowNumberFunctionId) && node.getOrderingScheme().isEmpty();
        }

        private Optional<TopNRankingNode.RankingType> toTopNRankingType(WindowNode node) {
            if (node.getWindowFunctions().size() != 1 || node.getOrderingScheme().isEmpty()) {
                return Optional.empty();
            }
            Symbol rankingSymbol = (Symbol)((Map.Entry)Iterables.getOnlyElement(node.getWindowFunctions().entrySet())).getKey();
            FunctionId functionId = node.getWindowFunctions().get(rankingSymbol).getResolvedFunction().getFunctionId();
            if (functionId.equals(this.rowNumberFunctionId)) {
                return Optional.of(TopNRankingNode.RankingType.ROW_NUMBER);
            }
            if (functionId.equals(this.rankFunctionId)) {
                return Optional.of(TopNRankingNode.RankingType.RANK);
            }
            return Optional.empty();
        }
    }
}

