/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.matching.Pattern;
import io.trino.matching.Property;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DeleteNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.UpdateNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Optional;

public final class Patterns {
    private Patterns() {
    }

    public static Pattern<AssignUniqueId> assignUniqueId() {
        return Pattern.typeOf(AssignUniqueId.class);
    }

    public static Pattern<AggregationNode> aggregation() {
        return Pattern.typeOf(AggregationNode.class);
    }

    public static Pattern<GroupIdNode> groupId() {
        return Pattern.typeOf(GroupIdNode.class);
    }

    public static Pattern<ApplyNode> applyNode() {
        return Pattern.typeOf(ApplyNode.class);
    }

    public static Pattern<DeleteNode> delete() {
        return Pattern.typeOf(DeleteNode.class);
    }

    public static Pattern<UpdateNode> update() {
        return Pattern.typeOf(UpdateNode.class);
    }

    public static Pattern<ExchangeNode> exchange() {
        return Pattern.typeOf(ExchangeNode.class);
    }

    public static Pattern<ExplainAnalyzeNode> explainAnalyze() {
        return Pattern.typeOf(ExplainAnalyzeNode.class);
    }

    public static Pattern<EnforceSingleRowNode> enforceSingleRow() {
        return Pattern.typeOf(EnforceSingleRowNode.class);
    }

    public static Pattern<FilterNode> filter() {
        return Pattern.typeOf(FilterNode.class);
    }

    public static Pattern<IndexJoinNode> indexJoin() {
        return Pattern.typeOf(IndexJoinNode.class);
    }

    public static Pattern<IndexSourceNode> indexSource() {
        return Pattern.typeOf(IndexSourceNode.class);
    }

    public static Pattern<JoinNode> join() {
        return Pattern.typeOf(JoinNode.class);
    }

    public static Pattern<SpatialJoinNode> spatialJoin() {
        return Pattern.typeOf(SpatialJoinNode.class);
    }

    public static Pattern<CorrelatedJoinNode> correlatedJoin() {
        return Pattern.typeOf(CorrelatedJoinNode.class);
    }

    public static Pattern<OffsetNode> offset() {
        return Pattern.typeOf(OffsetNode.class);
    }

    public static Pattern<LimitNode> limit() {
        return Pattern.typeOf(LimitNode.class);
    }

    public static Pattern<MarkDistinctNode> markDistinct() {
        return Pattern.typeOf(MarkDistinctNode.class);
    }

    public static Pattern<OutputNode> output() {
        return Pattern.typeOf(OutputNode.class);
    }

    public static Pattern<ProjectNode> project() {
        return Pattern.typeOf(ProjectNode.class);
    }

    public static Pattern<SampleNode> sample() {
        return Pattern.typeOf(SampleNode.class);
    }

    public static Pattern<SemiJoinNode> semiJoin() {
        return Pattern.typeOf(SemiJoinNode.class);
    }

    public static Pattern<SortNode> sort() {
        return Pattern.typeOf(SortNode.class);
    }

    public static Pattern<TableFinishNode> tableFinish() {
        return Pattern.typeOf(TableFinishNode.class);
    }

    public static Pattern<TableScanNode> tableScan() {
        return Pattern.typeOf(TableScanNode.class);
    }

    public static Pattern<TableWriterNode> tableWriterNode() {
        return Pattern.typeOf(TableWriterNode.class);
    }

    public static Pattern<TopNNode> topN() {
        return Pattern.typeOf(TopNNode.class);
    }

    public static Pattern<UnionNode> union() {
        return Pattern.typeOf(UnionNode.class);
    }

    public static Pattern<ValuesNode> values() {
        return Pattern.typeOf(ValuesNode.class);
    }

    public static Pattern<UnnestNode> unnest() {
        return Pattern.typeOf(UnnestNode.class);
    }

    public static Pattern<WindowNode> window() {
        return Pattern.typeOf(WindowNode.class);
    }

    public static Pattern<PatternRecognitionNode> patternRecognition() {
        return Pattern.typeOf(PatternRecognitionNode.class);
    }

    public static Pattern<RowNumberNode> rowNumber() {
        return Pattern.typeOf(RowNumberNode.class);
    }

    public static Pattern<TopNRankingNode> topNRanking() {
        return Pattern.typeOf(TopNRankingNode.class);
    }

    public static Pattern<DistinctLimitNode> distinctLimit() {
        return Pattern.typeOf(DistinctLimitNode.class);
    }

    public static Pattern<IntersectNode> intersect() {
        return Pattern.typeOf(IntersectNode.class);
    }

    public static Pattern<ExceptNode> except() {
        return Pattern.typeOf(ExceptNode.class);
    }

    public static Property<PlanNode, Lookup, PlanNode> source() {
        return Property.optionalProperty((String)"source", (node, lookup) -> {
            if (node.getSources().size() == 1) {
                PlanNode source = (PlanNode)Iterables.getOnlyElement(node.getSources());
                return Optional.of(lookup.resolve(source));
            }
            return Optional.empty();
        });
    }

    public static Property<PlanNode, Lookup, List<PlanNode>> sources() {
        return Property.property((String)"sources", (node, lookup) -> (List)node.getSources().stream().map(lookup::resolve).collect(ImmutableList.toImmutableList()));
    }

    public static final class Except {
        public static Property<ExceptNode, Lookup, Boolean> distinct() {
            return Property.property((String)"distinct", ExceptNode::isDistinct);
        }
    }

    public static final class Intersect {
        public static Property<IntersectNode, Lookup, Boolean> distinct() {
            return Property.property((String)"distinct", IntersectNode::isDistinct);
        }
    }

    public static final class SemiJoin {
        public static Property<SemiJoinNode, Lookup, PlanNode> getSource() {
            return Property.property((String)"source", (semiJoin, lookup) -> lookup.resolve(semiJoin.getSource()));
        }

        public static Property<SemiJoinNode, Lookup, PlanNode> getFilteringSource() {
            return Property.property((String)"filteringSource", (semiJoin, lookup) -> lookup.resolve(semiJoin.getFilteringSource()));
        }
    }

    public static final class Values {
        public static Property<ValuesNode, Lookup, Optional<List<Expression>>> rows() {
            return Property.property((String)"rows", ValuesNode::getRows);
        }

        public static Property<ValuesNode, Lookup, Integer> rowCount() {
            return Property.property((String)"rowCount", ValuesNode::getRowCount);
        }
    }

    public static final class TopN {
        public static Property<TopNNode, Lookup, TopNNode.Step> step() {
            return Property.property((String)"step", TopNNode::getStep);
        }

        public static Property<TopNNode, Lookup, Long> count() {
            return Property.property((String)"count", TopNNode::getCount);
        }
    }

    public static final class Sample {
        public static Property<SampleNode, Lookup, Double> sampleRatio() {
            return Property.property((String)"sampleRatio", SampleNode::getSampleRatio);
        }

        public static Property<SampleNode, Lookup, SampleNode.Type> sampleType() {
            return Property.property((String)"sampleType", SampleNode::getSampleType);
        }
    }

    public static final class Limit {
        public static Property<LimitNode, Lookup, Long> count() {
            return Property.property((String)"count", LimitNode::getCount);
        }
    }

    public static final class CorrelatedJoin {
        public static Property<CorrelatedJoinNode, Lookup, List<Symbol>> correlation() {
            return Property.property((String)"correlation", CorrelatedJoinNode::getCorrelation);
        }

        public static Property<CorrelatedJoinNode, Lookup, PlanNode> subquery() {
            return Property.property((String)"subquery", (node, context) -> context.resolve(node.getSubquery()));
        }

        public static Property<CorrelatedJoinNode, Lookup, Expression> filter() {
            return Property.property((String)"filter", CorrelatedJoinNode::getFilter);
        }

        public static Property<CorrelatedJoinNode, Lookup, CorrelatedJoinNode.Type> type() {
            return Property.property((String)"type", CorrelatedJoinNode::getType);
        }
    }

    public static final class Join {
        public static Property<JoinNode, Lookup, JoinNode.Type> type() {
            return Property.property((String)"type", JoinNode::getType);
        }

        public static Property<JoinNode, Lookup, PlanNode> left() {
            return Property.property((String)"left", (joinNode, lookup) -> lookup.resolve(joinNode.getLeft()));
        }

        public static Property<JoinNode, Lookup, PlanNode> right() {
            return Property.property((String)"right", (joinNode, lookup) -> lookup.resolve(joinNode.getRight()));
        }
    }

    public static final class Exchange {
        public static Property<ExchangeNode, Lookup, ExchangeNode.Scope> scope() {
            return Property.property((String)"scope", ExchangeNode::getScope);
        }
    }

    public static final class DistinctLimit {
        public static Property<DistinctLimitNode, Lookup, Boolean> isPartial() {
            return Property.property((String)"isPartial", DistinctLimitNode::isPartial);
        }
    }

    public static final class Apply {
        public static Property<ApplyNode, Lookup, List<Symbol>> correlation() {
            return Property.property((String)"correlation", ApplyNode::getCorrelation);
        }
    }

    public static final class Aggregation {
        public static Property<AggregationNode, Lookup, List<Symbol>> groupingColumns() {
            return Property.property((String)"groupingKeys", AggregationNode::getGroupingKeys);
        }

        public static Property<AggregationNode, Lookup, AggregationNode.Step> step() {
            return Property.property((String)"step", AggregationNode::getStep);
        }
    }
}

