/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.CatalogMetadata;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface TransactionManager {
    public static final IsolationLevel DEFAULT_ISOLATION = IsolationLevel.READ_UNCOMMITTED;
    public static final boolean DEFAULT_READ_ONLY = false;

    public boolean transactionExists(TransactionId var1);

    default public boolean isAutoCommit(TransactionId transactionId) {
        return this.getTransactionInfo(transactionId).isAutoCommitContext();
    }

    public TransactionInfo getTransactionInfo(TransactionId var1);

    public List<TransactionInfo> getAllTransactionInfos();

    public TransactionId beginTransaction(boolean var1);

    public TransactionId beginTransaction(IsolationLevel var1, boolean var2, boolean var3);

    public Map<String, CatalogName> getCatalogNames(TransactionId var1);

    public Optional<CatalogMetadata> getOptionalCatalogMetadata(TransactionId var1, String var2);

    public CatalogMetadata getCatalogMetadata(TransactionId var1, CatalogName var2);

    public CatalogMetadata getCatalogMetadataForWrite(TransactionId var1, CatalogName var2);

    public CatalogMetadata getCatalogMetadataForWrite(TransactionId var1, String var2);

    public ConnectorTransactionHandle getConnectorTransaction(TransactionId var1, CatalogName var2);

    public void checkAndSetActive(TransactionId var1);

    public void trySetActive(TransactionId var1);

    public void trySetInactive(TransactionId var1);

    public ListenableFuture<?> asyncCommit(TransactionId var1);

    public ListenableFuture<?> asyncAbort(TransactionId var1);

    public void fail(TransactionId var1);

    default public void activateTransaction(Session session, boolean transactionControl, AccessControl accessControl) {
        if (session.getTransactionId().isEmpty()) {
            return;
        }
        TransactionId transactionId = session.getTransactionId().get();
        if (transactionControl) {
            this.trySetActive(transactionId);
        } else {
            this.checkAndSetActive(transactionId);
        }
    }
}

