/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type.setdigest;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.type.setdigest.SetDigest;
import io.trino.type.setdigest.SetDigestState;
import io.trino.type.setdigest.SetDigestStateSerializer;

@AggregationFunction(value="make_set_digest")
public final class BuildSetDigestAggregation {
    private static final SetDigestStateSerializer SERIALIZER = new SetDigestStateSerializer();

    private BuildSetDigestAggregation() {
    }

    @InputFunction
    public static void input(SetDigestState state, @SqlType(value="bigint") long value) {
        if (state.getDigest() == null) {
            state.setDigest(new SetDigest());
        }
        state.getDigest().add(value);
    }

    @CombineFunction
    public static void combine(SetDigestState state, SetDigestState otherState) {
        if (state.getDigest() == null) {
            SetDigest copy = new SetDigest();
            copy.mergeWith(otherState.getDigest());
            state.setDigest(copy);
        } else {
            state.getDigest().mergeWith(otherState.getDigest());
        }
    }

    @OutputFunction(value="SetDigest")
    public static void output(SetDigestState state, BlockBuilder out) {
        SERIALIZER.serialize(state, out);
    }
}

