/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.FunctionDependencies;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public final class MinMaxCompare {
    private static final MethodHandle MIN_FUNCTION = Reflection.methodHandle(MinMaxCompare.class, "min", Long.TYPE);
    private static final MethodHandle MAX_FUNCTION = Reflection.methodHandle(MinMaxCompare.class, "max", Long.TYPE);
    public static final MethodHandle MAX_REAL_FUNCTION = Reflection.methodHandle(MinMaxCompare.class, "maxReal", Long.TYPE, Long.TYPE);
    public static final MethodHandle MAX_DOUBLE_FUNCTION = Reflection.methodHandle(MinMaxCompare.class, "maxDouble", Double.TYPE, Double.TYPE);

    private MinMaxCompare() {
    }

    public static MethodHandle getMinMaxCompare(FunctionDependencies dependencies, Type type, InvocationConvention convention, boolean min) {
        if (!min && type.equals(RealType.REAL)) {
            return MAX_REAL_FUNCTION;
        }
        if (!min && type.equals(DoubleType.DOUBLE)) {
            return MAX_DOUBLE_FUNCTION;
        }
        MethodHandle handle = dependencies.getOperatorInvoker(OperatorType.COMPARISON, List.of(type, type), convention).getMethodHandle();
        return MethodHandles.filterReturnValue(handle, min ? MIN_FUNCTION : MAX_FUNCTION);
    }

    public static BlockTypeOperators.BlockPositionComparison getMaxCompare(BlockTypeOperators operators, Type type) {
        if (type.equals(RealType.REAL)) {
            return (leftBlock, leftPosition, rightBlock, rightPosition) -> {
                float left = MinMaxCompare.toReal(RealType.REAL.getLong(leftBlock, leftPosition));
                float right = MinMaxCompare.toReal(RealType.REAL.getLong(rightBlock, rightPosition));
                if (Float.isNaN(left) && Float.isNaN(right)) {
                    return 0L;
                }
                if (Float.isNaN(left)) {
                    return -1L;
                }
                if (Float.isNaN(right)) {
                    return 1L;
                }
                return Float.compare(left, right);
            };
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return (leftBlock, leftPosition, rightBlock, rightPosition) -> {
                double left = DoubleType.DOUBLE.getDouble(leftBlock, leftPosition);
                double right = DoubleType.DOUBLE.getDouble(rightBlock, rightPosition);
                if (Double.isNaN(left) && Double.isNaN(right)) {
                    return 0L;
                }
                if (Double.isNaN(left)) {
                    return -1L;
                }
                if (Double.isNaN(right)) {
                    return 1L;
                }
                return Double.compare(left, right);
            };
        }
        return operators.getComparisonOperator(type);
    }

    @UsedByGeneratedCode
    public static boolean min(long comparisonResult) {
        return comparisonResult < 0L;
    }

    @UsedByGeneratedCode
    public static boolean max(long comparisonResult) {
        return comparisonResult > 0L;
    }

    @UsedByGeneratedCode
    public static boolean maxReal(long intLeft, long intRight) {
        float right;
        float left = MinMaxCompare.toReal(intLeft);
        return left > (right = MinMaxCompare.toReal(intRight)) || Float.isNaN(right);
    }

    @UsedByGeneratedCode
    public static boolean maxDouble(double left, double right) {
        return left > right || Double.isNaN(right);
    }

    private static float toReal(long value) {
        return Float.intBitsToFloat((int)value);
    }
}

