/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import io.trino.connector.Grants;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MutableGrants<T>
implements Grants<T> {
    private final Map<Grant, Boolean> grants = new HashMap<Grant, Boolean>();

    @Override
    public void grant(TrinoPrincipal principal, T objectName, Set<Privilege> privileges, boolean grantOption) {
        privileges.forEach(privilege -> {
            Grant grant = new Grant(principal, objectName, (Privilege)privilege);
            this.grants.put(grant, grantOption || this.grants.getOrDefault(grant, false) != false);
        });
    }

    @Override
    public void revoke(TrinoPrincipal principal, T objectName, Set<Privilege> privileges, boolean grantOption) {
        privileges.forEach(privilege -> this.grants.remove(new Grant(principal, objectName, (Privilege)privilege)));
    }

    @Override
    public boolean isAllowed(String user, T objectName, Privilege privilege) {
        return this.grants.containsKey(new Grant(new TrinoPrincipal(PrincipalType.USER, user), objectName, privilege));
    }

    @Override
    public boolean canGrant(String user, T objectName, Privilege privilege) {
        return this.grants.getOrDefault(new Grant(new TrinoPrincipal(PrincipalType.USER, user), objectName, privilege), false);
    }

    class Grant {
        private final TrinoPrincipal principal;
        private final T objectName;
        private final Privilege privilege;

        Grant(TrinoPrincipal principal, T objectName, Privilege privilege) {
            this.principal = Objects.requireNonNull(principal, "principal is null");
            this.objectName = Objects.requireNonNull(objectName, "objectName is null");
            this.privilege = Objects.requireNonNull(privilege, "privilege is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Grant grant = (Grant)o;
            return this.principal.equals((Object)grant.principal) && this.objectName.equals(grant.objectName) && this.privilege == grant.privilege;
        }

        public int hashCode() {
            return Objects.hash(this.principal, this.objectName, this.privilege);
        }
    }
}

