/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.PlanNodeStatsAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsProvider;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class StatsCalculatorAssertion {
    private final StatsCalculator statsCalculator;
    private final Session session;
    private final PlanNode planNode;
    private final TypeProvider types;
    private final Map<PlanNode, PlanNodeStatsEstimate> sourcesStats;

    public StatsCalculatorAssertion(StatsCalculator statsCalculator, Session session, PlanNode planNode, TypeProvider types) {
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator cannot be null");
        this.session = Objects.requireNonNull(session, "sesssion cannot be null");
        this.planNode = Objects.requireNonNull(planNode, "planNode is null");
        this.types = Objects.requireNonNull(types, "types is null");
        this.sourcesStats = new HashMap<PlanNode, PlanNodeStatsEstimate>();
        planNode.getSources().forEach(child -> this.sourcesStats.put((PlanNode)child, PlanNodeStatsEstimate.unknown()));
    }

    public StatsCalculatorAssertion withSourceStats(PlanNodeStatsEstimate sourceStats) {
        Preconditions.checkState((this.planNode.getSources().size() == 1 ? 1 : 0) != 0, (Object)"expected single source");
        return this.withSourceStats(0, sourceStats);
    }

    public StatsCalculatorAssertion withSourceStats(int sourceIndex, PlanNodeStatsEstimate sourceStats) {
        Preconditions.checkArgument((sourceIndex < this.planNode.getSources().size() ? 1 : 0) != 0, (String)"invalid sourceIndex %s; planNode has %s sources", (int)sourceIndex, (int)this.planNode.getSources().size());
        this.sourcesStats.put((PlanNode)this.planNode.getSources().get(sourceIndex), sourceStats);
        return this;
    }

    public StatsCalculatorAssertion withSourceStats(PlanNodeId planNodeId, PlanNodeStatsEstimate sourceStats) {
        PlanNode sourceNode = PlanNodeSearcher.searchFrom((PlanNode)this.planNode).where(node -> node.getId().equals((Object)planNodeId)).findOnlyElement();
        this.sourcesStats.put(sourceNode, sourceStats);
        return this;
    }

    public StatsCalculatorAssertion withSourceStats(Map<PlanNode, PlanNodeStatsEstimate> stats) {
        this.sourcesStats.putAll(stats);
        return this;
    }

    public StatsCalculatorAssertion check(Consumer<PlanNodeStatsAssertion> statisticsAssertionConsumer) {
        PlanNodeStatsEstimate statsEstimate = (PlanNodeStatsEstimate)TransactionBuilder.transaction((TransactionManager)new TestingTransactionManager(), (AccessControl)new AllowAllAccessControl()).execute(this.session, transactionSession -> this.statsCalculator.calculateStats(this.planNode, this::getSourceStats, Lookup.noLookup(), transactionSession, this.types));
        statisticsAssertionConsumer.accept(PlanNodeStatsAssertion.assertThat(statsEstimate));
        return this;
    }

    public StatsCalculatorAssertion check(ComposableStatsCalculator.Rule<?> rule, Consumer<PlanNodeStatsAssertion> statisticsAssertionConsumer) {
        Optional<PlanNodeStatsEstimate> statsEstimate = StatsCalculatorAssertion.calculatedStats(rule, this.planNode, this::getSourceStats, Lookup.noLookup(), this.session, this.types);
        Preconditions.checkState((boolean)statsEstimate.isPresent(), (Object)"Expected stats estimates to be present");
        statisticsAssertionConsumer.accept(PlanNodeStatsAssertion.assertThat(statsEstimate.get()));
        return this;
    }

    private static <T extends PlanNode> Optional<PlanNodeStatsEstimate> calculatedStats(ComposableStatsCalculator.Rule<T> rule, PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        return rule.calculate(node, sourceStats, lookup, session, types);
    }

    private PlanNodeStatsEstimate getSourceStats(PlanNode sourceNode) {
        Preconditions.checkArgument((boolean)this.sourcesStats.containsKey(sourceNode), (String)"stats not found for source %s", (Object)sourceNode);
        return this.sourcesStats.get(sourceNode);
    }
}

