/*
 * Decompiled with CFR 0.152.
 */
package io.trino.eventlistener;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.eventlistener.EventListener;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestConnectorEventListener {
    @Test
    public void testConnectorWithoutEventListener() {
        LocalQueryRunner queryRunner = LocalQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).build();
        queryRunner.loadEventListeners();
        Assertions.assertThatCode(() -> queryRunner.execute("SELECT 1")).doesNotThrowAnyException();
    }

    @Test
    public void testConnectorWithEventListener() {
        MockEventListenerFactory listenerFactory = new MockEventListenerFactory();
        LocalQueryRunner queryRunner = LocalQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).build();
        queryRunner.createCatalog("event_listening", (ConnectorFactory)new MockConnectorFactory.Builder().withEventListener(listenerFactory).build(), (Map)ImmutableMap.of());
        queryRunner.loadEventListeners();
        Assertions.assertThat((AtomicLong)listenerFactory.getEventListenerInvocationCounter).hasValue(1L);
    }

    private static class MockEventListenerFactory
    implements Supplier<EventListener> {
        private final AtomicLong getEventListenerInvocationCounter = new AtomicLong(0L);

        private MockEventListenerFactory() {
        }

        @Override
        public EventListener get() {
            this.getEventListenerInvocationCounter.incrementAndGet();
            return new EventListener(){};
        }
    }
}

