/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.CallTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.security.DenyAllAccessControl;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.AccessDeniedException;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCallTask {
    private ExecutorService executor;
    private static boolean invoked;

    @BeforeClass
    public void init() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"call-task-test-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void close() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @BeforeMethod
    public void cleanup() {
        invoked = false;
    }

    @Test
    public void testExecute() {
        this.executeCallTask(MethodHandleUtil.methodHandle(TestCallTask.class, (String)"testingMethod", (Class[])new Class[0]), transactionManager -> new AllowAllAccessControl());
        Assertions.assertThat((boolean)invoked).isTrue();
    }

    @Test
    public void testExecuteNoPermission() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeCallTask(MethodHandleUtil.methodHandle(TestCallTask.class, (String)"testingMethod", (Class[])new Class[0]), transactionManager -> new DenyAllAccessControl())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot execute procedure test.test.testing_procedure");
        Assertions.assertThat((boolean)invoked).isFalse();
    }

    @Test
    public void testExecuteNoPermissionOnInsert() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeCallTask(MethodHandleUtil.methodHandle(TestingProcedure.class, (String)"testingMethod", (Class[])new Class[]{ConnectorAccessControl.class}), transactionManager -> {
            TestingAccessControlManager accessControl = new TestingAccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager());
            accessControl.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
            accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"testing_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
            return accessControl;
        })).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table test.test.testing_table");
    }

    private void executeCallTask(MethodHandle methodHandle, Function<TransactionManager, AccessControl> accessControlProvider) {
        TransactionManager transactionManager = this.createTransactionManager();
        MetadataManager metadata = this.createMetadataManager(transactionManager, new Procedure("test", "testing_procedure", (List)ImmutableList.of(), methodHandle));
        AccessControl accessControl = accessControlProvider.apply(transactionManager);
        new CallTask().execute(new Call(QualifiedName.of((String)"testing_procedure"), (List)ImmutableList.of()), transactionManager, (Metadata)metadata, accessControl, this.stateMachine(transactionManager, metadata, accessControl), (List)ImmutableList.of(), WarningCollector.NOOP);
    }

    private TransactionManager createTransactionManager() {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)"test"));
        return InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
    }

    private MetadataManager createMetadataManager(TransactionManager transactionManager, Procedure procedure) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager((TransactionManager)transactionManager, (FeaturesConfig)new FeaturesConfig());
        metadata.getProcedureRegistry().addProcedures(new CatalogName("test"), (Collection)ImmutableList.of((Object)procedure));
        return metadata;
    }

    private QueryStateMachine stateMachine(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl) {
        return QueryStateMachine.begin((String)"CALL testing_procedure()", Optional.empty(), (Session)this.testSession(transactionManager), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
    }

    private Session testSession(TransactionManager transactionManager) {
        return TestingSession.testSessionBuilder().setCatalog("test").setSchema("test").setTransactionId(transactionManager.beginTransaction(true)).build();
    }

    public static void testingMethod() {
        invoked = true;
    }

    public static class TestingProcedure {
        public static void testingMethod(ConnectorAccessControl connectorAccessControl) {
            connectorAccessControl.checkCanInsertIntoTable(null, new SchemaTableName("test", "testing_table"));
        }
    }
}

