/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.cost.StatsCalculator;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.CreateMaterializedViewTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.TableSchema;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.sql.QueryUtil;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingGroupProvider;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateMaterializedViewTask {
    private static final String CATALOG_NAME = "catalog";
    private static final ConnectorTableMetadata MOCK_TABLE = new ConnectorTableMetadata(new SchemaTableName("schema", "mock_table"), List.of(new ColumnMetadata("a", (Type)SmallintType.SMALLINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)"baz", (Object)"property_value"));
    private Session testSession;
    private MockMetadata metadata;
    private TransactionManager transactionManager;
    private SqlParser parser;
    private StatsCalculator statsCalculator;
    private QueryStateMachine queryStateMachine;

    @BeforeMethod
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        MaterializedViewPropertyManager materializedViewPropertyManager = new MaterializedViewPropertyManager();
        Catalog testCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        catalogManager.registerCatalog(testCatalog);
        tablePropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false)));
        materializedViewPropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"foo", (String)"test materialized view property", null, (boolean)false)));
        this.testSession = TestingSession.testSessionBuilder().setTransactionId(this.transactionManager.beginTransaction(false)).build();
        this.metadata = new MockMetadata(tablePropertyManager, materializedViewPropertyManager, testCatalog.getConnectorCatalogName());
        this.parser = new SqlParser();
        this.statsCalculator = StatsCalculator.noopStatsCalculator();
        this.queryStateMachine = this.stateMachine(this.transactionManager, MetadataManager.createTestMetadataManager(), (AccessControl)new AllowAllAccessControl());
    }

    @Test
    public void testCreateMaterializedViewIfNotExists() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{"schema", "mock_table"}))), false, true, (List)ImmutableList.of(), Optional.empty());
        MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.parser, (GroupProvider)new TestingGroupProvider(), this.statsCalculator).execute(statement, this.transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP));
        Assert.assertEquals((int)this.metadata.getCreateMaterializedViewCallCount(), (int)1);
    }

    @Test
    public void testCreateMaterializedViewWithExistingView() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{"schema", "mock_table"}))), false, false, (List)ImmutableList.of(), Optional.empty());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.parser, (GroupProvider)new TestingGroupProvider(), this.statsCalculator).execute(statement, this.transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS).hasMessage("Materialized view already exists");
        Assert.assertEquals((int)this.metadata.getCreateMaterializedViewCallCount(), (int)1);
    }

    @Test
    public void testCreateMaterializedViewWithInvalidProperty() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{"schema", "mock_table"}))), false, true, (List)ImmutableList.of((Object)new Property(new Identifier("baz"), (Expression)new StringLiteral("abc"))), Optional.empty());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.parser, (GroupProvider)new TestingGroupProvider(), this.statsCalculator).execute(statement, this.transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_MATERIALIZED_VIEW_PROPERTY).hasMessage("Catalog 'catalog' does not support materialized view property 'baz'");
        Assert.assertEquals((int)this.metadata.getCreateMaterializedViewCallCount(), (int)0);
    }

    @Test
    public void testCreateDenyPermission() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{"schema", "mock_table"}))), false, true, (List)ImmutableList.of(), Optional.empty());
        TestingAccessControlManager accessControl = new TestingAccessControlManager(this.transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager());
        accessControl.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_mv", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_MATERIALIZED_VIEW)});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.parser, (GroupProvider)new TestingGroupProvider(), this.statsCalculator).execute(statement, this.transactionManager, (Metadata)this.metadata, (AccessControl)accessControl, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP))).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Cannot create materialized view catalog.schema.test_mv");
    }

    private QueryStateMachine stateMachine(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl) {
        return QueryStateMachine.begin((String)"test", Optional.empty(), (Session)this.testSession, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)MoreExecutors.directExecutor(), (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private final TablePropertyManager tablePropertyManager;
        private final MaterializedViewPropertyManager materializedViewPropertyManager;
        private final CatalogName catalogHandle;
        private final Map<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViews = new ConcurrentHashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();

        public MockMetadata(TablePropertyManager tablePropertyManager, MaterializedViewPropertyManager materializedViewPropertyManager, CatalogName catalogHandle) {
            this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
            this.materializedViewPropertyManager = Objects.requireNonNull(materializedViewPropertyManager, "materializedViewPropertyManager is null");
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        }

        @Override
        public void createMaterializedView(Session session, QualifiedObjectName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
            this.materializedViews.put(viewName.asSchemaTableName(), definition);
            if (!ignoreExisting) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists");
            }
        }

        @Override
        public TablePropertyManager getTablePropertyManager() {
            return this.tablePropertyManager;
        }

        @Override
        public MaterializedViewPropertyManager getMaterializedViewPropertyManager() {
            return this.materializedViewPropertyManager;
        }

        @Override
        public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogHandle.getCatalogName().equals(catalogName)) {
                return Optional.of(this.catalogHandle);
            }
            return Optional.empty();
        }

        @Override
        public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
            return new TableSchema(tableHandle.getCatalogName(), MOCK_TABLE.getTableSchema());
        }

        @Override
        public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
            if (tableName.asSchemaTableName().equals((Object)MOCK_TABLE.getTable())) {
                return Optional.of(new TableHandle(new CatalogName(TestCreateMaterializedViewTask.CATALOG_NAME), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(tableName.asSchemaTableName()), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, Optional.empty()));
            }
            return Optional.empty();
        }

        @Override
        public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
            return (Map)MOCK_TABLE.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new TestingColumnHandle(column.getName())));
        }

        @Override
        public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
            if (tableHandle.getConnectorHandle() instanceof TestingMetadata.TestingTableHandle && ((TestingMetadata.TestingTableHandle)tableHandle.getConnectorHandle()).getTableName().equals((Object)MOCK_TABLE.getTable())) {
                return new TableMetadata(new CatalogName(TestCreateMaterializedViewTask.CATALOG_NAME), MOCK_TABLE);
            }
            return super.getTableMetadata(session, tableHandle);
        }

        @Override
        public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
            return Optional.ofNullable(this.materializedViews.get(viewName.asSchemaTableName()));
        }

        @Override
        public Optional<ConnectorViewDefinition> getView(Session session, QualifiedObjectName viewName) {
            return Optional.empty();
        }

        public int getCreateMaterializedViewCallCount() {
            return this.materializedViews.size();
        }
    }
}

