/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.CreateTableTask;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateTableTask {
    private static final String CATALOG_NAME = "catalog";
    private static final ConnectorTableMetadata PARENT_TABLE = new ConnectorTableMetadata(new SchemaTableName("schema", "parent_table"), List.of(new ColumnMetadata("a", (Type)SmallintType.SMALLINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)), Map.of("baz", "property_value"));
    private Session testSession;
    private MockMetadata metadata;
    private TransactionManager transactionManager;

    @BeforeMethod
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        MaterializedViewPropertyManager materializedViewPropertyManager = new MaterializedViewPropertyManager();
        ColumnPropertyManager columnPropertyManager = new ColumnPropertyManager();
        Catalog testCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        catalogManager.registerCatalog(testCatalog);
        tablePropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false)));
        materializedViewPropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"foo", (String)"test materialized view property", null, (boolean)false)));
        columnPropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of());
        this.testSession = TestingSession.testSessionBuilder().setTransactionId(this.transactionManager.beginTransaction(false)).build();
        this.metadata = new MockMetadata(tablePropertyManager, materializedViewPropertyManager, columnPropertyManager, testCatalog.getConnectorCatalogName(), Collections.emptySet());
    }

    @Test
    public void testCreateTableNotExistsTrue() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), true, (List)ImmutableList.of(), Optional.empty());
        MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
    }

    @Test
    public void testCreateTableNotExistsFalse() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), false, (List)ImmutableList.of(), Optional.empty());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList(), output -> {}))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS).hasMessage("Table already exists");
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
    }

    @Test
    public void testCreateTableWithMaterializedViewPropertyFails() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), false, (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new StringLiteral("bar"))), Optional.empty());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList(), output -> {}))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY).hasMessage("Catalog 'catalog' does not support table property 'foo'");
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)0);
    }

    @Test
    public void testCreateWithNotNullColumns() {
        this.metadata.setConnectorCapabilities(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT);
        ImmutableList inputColumns = ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"b"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR), false, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TypeSignatureTranslator.toSqlType((Type)VarbinaryType.VARBINARY), false, Collections.emptyList(), Optional.empty()));
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)inputColumns, true, (List)ImmutableList.of(), Optional.empty());
        MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
        List columns = this.metadata.getReceivedTableMetadata().get(0).getColumns();
        Assert.assertEquals((int)columns.size(), (int)3);
        Assert.assertEquals((String)((ColumnMetadata)columns.get(0)).getName(), (String)"a");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(0)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"DATE");
        Assert.assertTrue((boolean)((ColumnMetadata)columns.get(0)).isNullable());
        Assert.assertEquals((String)((ColumnMetadata)columns.get(1)).getName(), (String)"b");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(1)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"VARCHAR");
        Assert.assertFalse((boolean)((ColumnMetadata)columns.get(1)).isNullable());
        Assert.assertEquals((String)((ColumnMetadata)columns.get(2)).getName(), (String)"c");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(2)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"VARBINARY");
        Assert.assertFalse((boolean)((ColumnMetadata)columns.get(2)).isNullable());
    }

    @Test
    public void testCreateWithUnsupportedConnectorThrowsWhenNotNull() {
        ImmutableList inputColumns = ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"b"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR), false, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TypeSignatureTranslator.toSqlType((Type)VarbinaryType.VARBINARY), false, Collections.emptyList(), Optional.empty()));
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)inputColumns, true, (List)ImmutableList.of(), Optional.empty());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList(), output -> {}))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage("Catalog 'catalog' does not support non-null column for column name 'b'");
    }

    @Test
    public void testCreateLike() {
        CreateTable statement = this.getCreatleLikeStatement(false);
        MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, List.of(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
        Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)PARENT_TABLE.getColumns());
        Assertions.assertThat((Map)this.metadata.getReceivedTableMetadata().get(0).getProperties()).isEmpty();
    }

    @Test
    public void testCreateLikeWithProperties() {
        CreateTable statement = this.getCreatleLikeStatement(true);
        MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, List.of(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
        Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)PARENT_TABLE.getColumns());
        Assertions.assertThat((Map)this.metadata.getReceivedTableMetadata().get(0).getProperties()).isEqualTo((Object)PARENT_TABLE.getProperties());
    }

    @Test
    public void testCreateLikeDenyPermission() {
        CreateTable statement = this.getCreatleLikeStatement(false);
        TestingAccessControlManager accessControl = new TestingAccessControlManager(this.transactionManager, new EventListenerManager(new EventListenerConfig()));
        accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"parent_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)accessControl, this.testSession, List.of(), output -> {}))).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Cannot reference columns of table");
    }

    @Test
    public void testCreateLikeWithPropertiesDenyPermission() {
        CreateTable statement = this.getCreatleLikeStatement(true);
        TestingAccessControlManager accessControl = new TestingAccessControlManager(this.transactionManager, new EventListenerManager(new EventListenerConfig()));
        accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"parent_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE)});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)accessControl, this.testSession, List.of(), output -> {}))).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Cannot reference properties of table");
    }

    private CreateTable getCreatleLikeStatement(boolean includingProperties) {
        return new CreateTable(QualifiedName.of((String)"test_table"), List.of(new LikeClause(QualifiedName.of((String)PARENT_TABLE.getTable().getTableName()), includingProperties ? Optional.of(LikeClause.PropertiesOption.INCLUDING) : Optional.empty())), true, (List)ImmutableList.of(), Optional.empty());
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private final MetadataManager metadata;
        private final TablePropertyManager tablePropertyManager;
        private final MaterializedViewPropertyManager materializedViewPropertyManager;
        private final ColumnPropertyManager columnPropertyManager;
        private final CatalogName catalogHandle;
        private final List<ConnectorTableMetadata> tables = new CopyOnWriteArrayList<ConnectorTableMetadata>();
        private Set<ConnectorCapabilities> connectorCapabilities;

        public MockMetadata(TablePropertyManager tablePropertyManager, MaterializedViewPropertyManager materializedViewPropertyManager, ColumnPropertyManager columnPropertyManager, CatalogName catalogHandle, Set<ConnectorCapabilities> connectorCapabilities) {
            this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
            this.materializedViewPropertyManager = Objects.requireNonNull(materializedViewPropertyManager, "materializedViewPropertyManager is null");
            this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            this.connectorCapabilities = Sets.immutableEnumSet((Iterable)Objects.requireNonNull(connectorCapabilities, "connectorCapabilities is null"));
            this.metadata = MetadataManager.createTestMetadataManager();
        }

        @Override
        public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
            this.tables.add(tableMetadata);
            if (!ignoreExisting) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists");
            }
        }

        @Override
        public TablePropertyManager getTablePropertyManager() {
            return this.tablePropertyManager;
        }

        @Override
        public MaterializedViewPropertyManager getMaterializedViewPropertyManager() {
            return this.materializedViewPropertyManager;
        }

        @Override
        public ColumnPropertyManager getColumnPropertyManager() {
            return this.columnPropertyManager;
        }

        @Override
        public Type getType(TypeSignature signature) {
            return this.metadata.getType(signature);
        }

        @Override
        public Type getType(TypeId id) {
            return this.metadata.getType(id);
        }

        @Override
        public Type fromSqlType(String sqlType) {
            return this.metadata.fromSqlType(sqlType);
        }

        @Override
        public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogHandle.getCatalogName().equals(catalogName)) {
                return Optional.of(this.catalogHandle);
            }
            return Optional.empty();
        }

        @Override
        public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
            if (tableName.asSchemaTableName().equals((Object)PARENT_TABLE.getTable())) {
                return Optional.of(new TableHandle(new CatalogName(TestCreateTableTask.CATALOG_NAME), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(tableName.asSchemaTableName()), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, Optional.empty()));
            }
            return Optional.empty();
        }

        @Override
        public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
            if (tableHandle.getConnectorHandle() instanceof TestingMetadata.TestingTableHandle && ((TestingMetadata.TestingTableHandle)tableHandle.getConnectorHandle()).getTableName().equals((Object)PARENT_TABLE.getTable())) {
                return new TableMetadata(new CatalogName(TestCreateTableTask.CATALOG_NAME), PARENT_TABLE);
            }
            return super.getTableMetadata(session, tableHandle);
        }

        public int getCreateTableCallCount() {
            return this.tables.size();
        }

        public List<ConnectorTableMetadata> getReceivedTableMetadata() {
            return this.tables;
        }

        @Override
        public void dropColumn(Session session, TableHandle tableHandle, ColumnHandle column) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogName catalogName) {
            return this.connectorCapabilities;
        }

        public void setConnectorCapabilities(ConnectorCapabilities ... connectorCapabilities) {
            this.connectorCapabilities = Sets.immutableEnumSet((Iterable)ImmutableList.copyOf((Object[])connectorCapabilities));
        }
    }
}

