/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.trino.execution.ParameterExtractor;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestParameterExtractor {
    private final SqlParser sqlParser = new SqlParser();

    @Test
    public void testNoParameter() {
        Statement statement = this.sqlParser.createStatement("SELECT c1, c2 FROM test_table WHERE c1 = 1 AND c2 > 2", new ParsingOptions());
        Assertions.assertThat((List)ParameterExtractor.getParameters((Statement)statement)).isEmpty();
        Assertions.assertThat((int)ParameterExtractor.getParameterCount((Statement)statement)).isEqualTo(0);
    }

    @Test
    public void testParameterCount() {
        Statement statement = this.sqlParser.createStatement("SELECT c1, c2 FROM test_table WHERE c1 = ? AND c2 > ?", new ParsingOptions());
        Assertions.assertThat((List)ParameterExtractor.getParameters((Statement)statement)).containsExactly((Object[])new Parameter[]{new Parameter(new NodeLocation(1, 41), 0), new Parameter(new NodeLocation(1, 52), 1)});
        Assertions.assertThat((int)ParameterExtractor.getParameterCount((Statement)statement)).isEqualTo(2);
    }

    @Test
    public void testShowStats() {
        Statement statement = this.sqlParser.createStatement("SHOW STATS FOR (SELECT c1, c2 FROM test_table WHERE c1 = ? AND c2 > ?)", new ParsingOptions());
        Assertions.assertThat((List)ParameterExtractor.getParameters((Statement)statement)).containsExactly((Object[])new Parameter[]{new Parameter(new NodeLocation(1, 57), 0), new Parameter(new NodeLocation(1, 68), 1)});
        Assertions.assertThat((int)ParameterExtractor.getParameterCount((Statement)statement)).isEqualTo(2);
    }

    @Test
    public void testLambda() {
        Statement statement = this.sqlParser.createStatement("SELECT * FROM test_table WHERE any_match(items, x -> x > ?)", new ParsingOptions());
        Assertions.assertThat((List)ParameterExtractor.getParameters((Statement)statement)).containsExactly((Object[])new Parameter[]{new Parameter(new NodeLocation(1, 58), 0)});
        Assertions.assertThat((int)ParameterExtractor.getParameterCount((Statement)statement)).isEqualTo(1);
    }
}

