/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.SerializedPage;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.MetadataManager;
import io.trino.operator.PageAssertions;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.AesSpillCipher;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1)
@Warmup(iterations=12, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.Throughput})
public class BenchmarkPagesSerde {
    @Benchmark
    public void serialize(BenchmarkData data, Blackhole blackhole) {
        Page[] pages = data.dataPages;
        PagesSerde serde = data.serde;
        try (PagesSerde.PagesSerdeContext context = serde.newContext();){
            for (int i = 0; i < pages.length; ++i) {
                blackhole.consume((Object)serde.serialize(context, pages[i]));
            }
        }
    }

    @Benchmark
    public void deserialize(BenchmarkData data, Blackhole blackhole) {
        SerializedPage[] serializedPages = data.serializedPages;
        PagesSerde serde = data.serde;
        try (PagesSerde.PagesSerdeContext context = serde.newContext();){
            for (int i = 0; i < serializedPages.length; ++i) {
                blackhole.consume((Object)serde.deserialize(context, serializedPages[i]));
            }
        }
    }

    @Test
    public void testBenchmarkData() {
        BenchmarkData data = new BenchmarkData();
        data.compressed = true;
        data.initialize();
        SerializedPage[] serializedPages = data.serializedPages;
        PagesSerde serde = data.serde;
        try (PagesSerde.PagesSerdeContext context = serde.newContext();){
            for (int i = 0; i < serializedPages.length; ++i) {
                PageAssertions.assertPageEquals(BenchmarkData.TYPES, serde.deserialize(context, serializedPages[i]), data.dataPages[i]);
            }
        }
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.compressed = true;
        data.initialize();
        System.out.println("Page Size Avg: " + Arrays.stream(data.dataPages).mapToLong(Page::getSizeInBytes).average().getAsDouble());
        System.out.println("Page Size Min: " + Arrays.stream(data.dataPages).mapToLong(Page::getSizeInBytes).min().getAsLong());
        System.out.println("Page Size Max: " + Arrays.stream(data.dataPages).mapToLong(Page::getSizeInBytes).max().getAsLong());
        System.out.println("Page Size Sum: " + Arrays.stream(data.dataPages).mapToLong(Page::getSizeInBytes).sum());
        System.out.println("Page count: " + data.dataPages.length);
        System.out.println("Compressed: " + Arrays.stream(data.serializedPages).filter(SerializedPage::isCompressed).count());
        Benchmarks.benchmark(BenchmarkPagesSerde.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgs(new String[]{"-Xms4g", "-Xmx4g"})).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int ROW_COUNT = 15000;
        private static final List<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR);
        @Param(value={"true", "false"})
        private boolean encrypted;
        @Param(value={"true", "false"})
        private boolean compressed;
        @Param(value={"1000"})
        private int randomSeed = 1000;
        private PagesSerde serde;
        private Page[] dataPages;
        private SerializedPage[] serializedPages;

        @Setup
        public void initialize() {
            this.serde = this.createPagesSerde();
            this.dataPages = this.createPages();
            this.serializedPages = this.createSerializedPages();
        }

        public Page[] getDataPages() {
            return this.dataPages;
        }

        private PagesSerde createPagesSerde() {
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory(MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), this.compressed);
            return this.encrypted ? serdeFactory.createPagesSerdeForSpill(Optional.of(new AesSpillCipher())) : serdeFactory.createPagesSerde();
        }

        private SerializedPage[] createSerializedPages() {
            SerializedPage[] result = new SerializedPage[this.dataPages.length];
            try (PagesSerde.PagesSerdeContext context = this.serde.newContext();){
                for (int i = 0; i < result.length; ++i) {
                    result[i] = this.serde.serialize(context, this.dataPages[i]);
                }
            }
            return result;
        }

        private Page[] createPages() {
            Random random = new Random(this.randomSeed);
            ArrayList<Page> pages = new ArrayList<Page>();
            int remainingRows = 15000;
            PageBuilder pageBuilder = new PageBuilder(TYPES);
            while (remainingRows > 0) {
                int rows = 100 + random.nextInt(900);
                List<Object>[] testRows = this.generateTestRows(random, TYPES, rows);
                remainingRows -= rows;
                for (int i = 0; i < testRows.length; ++i) {
                    this.writeRow(testRows[i], pageBuilder.getBlockBuilder(0));
                }
                pageBuilder.declarePositions(rows);
                pages.add(pageBuilder.build());
                pageBuilder.reset();
            }
            return (Page[])pages.toArray(Page[]::new);
        }

        private void writeRow(List<Object> testRow, BlockBuilder blockBuilder) {
            for (Object fieldValue : testRow) {
                if (fieldValue == null) {
                    blockBuilder.appendNull();
                    continue;
                }
                if (fieldValue instanceof String) {
                    VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)fieldValue)));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }

        private List<Object>[] generateTestRows(Random random, List<Type> fieldTypes, int numRows) {
            List[] testRows = new List[numRows];
            for (int i = 0; i < numRows; ++i) {
                ArrayList testRow = new ArrayList(fieldTypes.size());
                for (int j = 0; j < fieldTypes.size(); ++j) {
                    if (fieldTypes.get(j) == VarcharType.VARCHAR) {
                        int mode = random.nextInt(4);
                        if (mode == 0) {
                            testRow.add(null);
                            continue;
                        }
                        if (i > 0 && mode == 1) {
                            testRow.add(testRows[i - 1].get(j));
                            continue;
                        }
                        byte[] data = new byte[random.nextInt(256)];
                        random.nextBytes(data);
                        testRow.add(new String(data, StandardCharsets.ISO_8859_1));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                testRows[i] = testRow;
            }
            return testRows;
        }
    }
}

