/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor;

import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.trino.execution.executor.Histogram;
import io.trino.execution.executor.SplitSpecification;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

final class SplitGenerators {
    private SplitGenerators() {
    }

    public static void main(String[] args) {
        Histogram<Long> bins = Histogram.fromContinuous(ImmutableList.of((Object)TimeUnit.MILLISECONDS.toNanos(0L), (Object)TimeUnit.MILLISECONDS.toNanos(1L), (Object)TimeUnit.MILLISECONDS.toNanos(10L), (Object)TimeUnit.MILLISECONDS.toNanos(100L), (Object)TimeUnit.MILLISECONDS.toNanos(1000L), (Object)TimeUnit.MILLISECONDS.toNanos(10000L), (Object)TimeUnit.MILLISECONDS.toNanos(60000L), (Object)TimeUnit.MILLISECONDS.toNanos(300000L), (Object)TimeUnit.MINUTES.toNanos(20L), (Object)TimeUnit.DAYS.toNanos(1L)));
        IntermediateSplitGenerator intermediateSplitGenerator = new IntermediateSplitGenerator(null);
        ArrayList<SplitSpecification.IntermediateSplitSpecification> intermediateSpecs = new ArrayList<SplitSpecification.IntermediateSplitSpecification>();
        for (int i = 0; i < 10000; ++i) {
            SplitSpecification.IntermediateSplitSpecification next = intermediateSplitGenerator.next();
            intermediateSpecs.add(next);
        }
        System.out.println("Scheduled time distributions");
        System.out.println("============================");
        System.out.println();
        System.out.println("Tasks with 8x " + IntermediateSplitGenerator.class.getSimpleName());
        bins.printDistribution(intermediateSpecs, t -> t.getScheduledTimeNanos() * 8L, a -> 1, Duration::succinctNanos, a -> "");
        ImmutableList leafSplitGenerators = ImmutableList.of((Object)new FastLeafSplitGenerator(), (Object)new SlowLeafSplitGenerator(), (Object)new L4LeafSplitGenerator(), (Object)new QuantaExceedingSplitGenerator(), (Object)new AggregatedLeafSplitGenerator());
        for (SplitGenerator generator : leafSplitGenerators) {
            ArrayList<SplitSpecification> leafSpecs = new ArrayList<SplitSpecification>();
            for (int i = 0; i < 17000; ++i) {
                leafSpecs.add(generator.next());
            }
            System.out.println();
            System.out.println("Tasks with 4x " + generator.getClass().getSimpleName());
            bins.printDistribution(leafSpecs, t -> t.getScheduledTimeNanos() * 4L, Duration::succinctNanos);
            System.out.println("Per quanta:");
            bins.printDistribution(leafSpecs, SplitSpecification::getPerQuantaNanos, Duration::succinctNanos);
        }
    }

    private static long generateLeafSplitScheduledTimeMs(double origin, double bound) {
        ThreadLocalRandom generator = ThreadLocalRandom.current();
        double value = generator.nextDouble(origin, bound);
        if (value > 0.998) {
            return generator.nextLong(300000L, 600000L);
        }
        if (value > 0.99) {
            return generator.nextLong(60000L, 300000L);
        }
        if (value > 0.95) {
            return generator.nextLong(10000L, 60000L);
        }
        if (value > 0.5) {
            return generator.nextLong(1000L, 10000L);
        }
        if (value > 0.25) {
            return generator.nextLong(100L, 1000L);
        }
        if (value > 0.1) {
            return generator.nextLong(10L, 100L);
        }
        return generator.nextLong(1L, 10L);
    }

    private static long generateLeafSplitPerCallMicros(double origin, double bound) {
        ThreadLocalRandom generator = ThreadLocalRandom.current();
        double value = generator.nextDouble(origin, bound);
        if (value > 0.9999) {
            return 200000000L;
        }
        if (value > 0.99) {
            return generator.nextLong(3000000L, 15000000L);
        }
        if (value > 0.95) {
            return generator.nextLong(2000000L, 5000000L);
        }
        if (value > 0.9) {
            return generator.nextLong(1500000L, 5000000L);
        }
        if (value > 0.75) {
            return generator.nextLong(1000000L, 2000000L);
        }
        if (value > 0.5) {
            return generator.nextLong(500000L, 1000000L);
        }
        if (value > 0.1) {
            return generator.nextLong(100000L, 500000L);
        }
        return generator.nextLong(250L, 500L);
    }

    private static long generateIntermediateSplitScheduledTimeMs(double origin, double bound) {
        ThreadLocalRandom generator = ThreadLocalRandom.current();
        double value = generator.nextDouble(origin, bound);
        if (value > 0.999) {
            return generator.nextLong(300000L, 600000L);
        }
        if (value > 0.99) {
            return generator.nextLong(60000L, 300000L);
        }
        if (value > 0.95) {
            return generator.nextLong(10000L, 60000L);
        }
        if (value > 0.75) {
            return generator.nextLong(1000L, 10000L);
        }
        if (value > 0.45) {
            return generator.nextLong(100L, 1000L);
        }
        if (value > 0.2) {
            return generator.nextLong(10L, 100L);
        }
        return generator.nextLong(1L, 10L);
    }

    private static long generateIntermediateSplitWallTimeMs(double origin, double bound) {
        ThreadLocalRandom generator = ThreadLocalRandom.current();
        double value = generator.nextDouble(origin, bound);
        if (value > 0.9) {
            return generator.nextLong(400000L, 800000L);
        }
        if (value > 0.75) {
            return generator.nextLong(100000L, 200000L);
        }
        if (value > 0.5) {
            return generator.nextLong(50000L, 100000L);
        }
        if (value > 0.4) {
            return generator.nextLong(30000L, 50000L);
        }
        if (value > 0.3) {
            return generator.nextLong(20000L, 30000L);
        }
        if (value > 0.2) {
            return generator.nextLong(10000L, 15000L);
        }
        if (value > 0.1) {
            return generator.nextLong(5000L, 10000L);
        }
        return generator.nextLong(1000L, 5000L);
    }

    private static long generateIntermediateSplitNumQuanta(double origin, double bound) {
        ThreadLocalRandom generator = ThreadLocalRandom.current();
        double value = generator.nextDouble(origin, bound);
        if (value > 0.95) {
            return generator.nextLong(2000L, 20000L);
        }
        if (value > 0.9) {
            return generator.nextLong(1000L, 2000L);
        }
        return generator.nextLong(10L, 1000L);
    }

    public static class SimpleLeafSplitGenerator
    implements SplitGenerator {
        private final long totalNanos;
        private final long quantaNanos;

        public SimpleLeafSplitGenerator(long totalNanos, long quantaNanos) {
            this.totalNanos = totalNanos;
            this.quantaNanos = quantaNanos;
        }

        @Override
        public SplitSpecification.LeafSplitSpecification next() {
            return new SplitSpecification.LeafSplitSpecification(this.totalNanos, this.quantaNanos);
        }
    }

    public static class QuantaExceedingSplitGenerator
    implements SplitGenerator {
        @Override
        public SplitSpecification.LeafSplitSpecification next() {
            long totalNanos = TimeUnit.MILLISECONDS.toNanos(SplitGenerators.generateLeafSplitScheduledTimeMs(0.99, 1.0));
            long quantaNanos = Math.min(totalNanos, TimeUnit.MICROSECONDS.toNanos(SplitGenerators.generateLeafSplitPerCallMicros(0.75, 1.0)));
            return new SplitSpecification.LeafSplitSpecification(totalNanos, quantaNanos);
        }
    }

    public static class L4LeafSplitGenerator
    implements SplitGenerator {
        @Override
        public SplitSpecification.LeafSplitSpecification next() {
            long totalNanos = TimeUnit.MILLISECONDS.toNanos(SplitGenerators.generateLeafSplitScheduledTimeMs(0.99, 1.0));
            long quantaNanos = Math.min(totalNanos, TimeUnit.MICROSECONDS.toNanos(SplitGenerators.generateLeafSplitPerCallMicros(0.0, 0.9)));
            return new SplitSpecification.LeafSplitSpecification(totalNanos, quantaNanos);
        }
    }

    public static class SlowLeafSplitGenerator
    implements SplitGenerator {
        @Override
        public SplitSpecification.LeafSplitSpecification next() {
            long totalNanos = TimeUnit.MILLISECONDS.toNanos(SplitGenerators.generateLeafSplitScheduledTimeMs(0.75, 1.0));
            long quantaNanos = Math.min(totalNanos, TimeUnit.MICROSECONDS.toNanos(SplitGenerators.generateLeafSplitPerCallMicros(0.0, 1.0)));
            return new SplitSpecification.LeafSplitSpecification(totalNanos, quantaNanos);
        }
    }

    public static class FastLeafSplitGenerator
    implements SplitGenerator {
        @Override
        public SplitSpecification.LeafSplitSpecification next() {
            long totalNanos = TimeUnit.MILLISECONDS.toNanos(SplitGenerators.generateLeafSplitScheduledTimeMs(0.0, 0.75));
            long quantaNanos = Math.min(totalNanos, TimeUnit.MICROSECONDS.toNanos(SplitGenerators.generateLeafSplitPerCallMicros(0.0, 1.0)));
            return new SplitSpecification.LeafSplitSpecification(totalNanos, quantaNanos);
        }
    }

    public static class AggregatedLeafSplitGenerator
    implements SplitGenerator {
        @Override
        public SplitSpecification.LeafSplitSpecification next() {
            long totalNanos = TimeUnit.MILLISECONDS.toNanos(SplitGenerators.generateLeafSplitScheduledTimeMs(0.0, 1.0));
            long quantaNanos = Math.min(totalNanos, TimeUnit.MICROSECONDS.toNanos(SplitGenerators.generateLeafSplitPerCallMicros(0.0, 1.0)));
            return new SplitSpecification.LeafSplitSpecification(totalNanos, quantaNanos);
        }
    }

    public static class IntermediateSplitGenerator
    implements SplitGenerator {
        private final ScheduledExecutorService wakeupExecutor;

        IntermediateSplitGenerator(ScheduledExecutorService wakeupExecutor) {
            this.wakeupExecutor = wakeupExecutor;
        }

        @Override
        public SplitSpecification.IntermediateSplitSpecification next() {
            long numQuanta = SplitGenerators.generateIntermediateSplitNumQuanta(0.0, 1.0);
            long wallNanos = TimeUnit.MILLISECONDS.toNanos(SplitGenerators.generateIntermediateSplitWallTimeMs(0.0, 1.0));
            long scheduledNanos = TimeUnit.MILLISECONDS.toNanos(SplitGenerators.generateIntermediateSplitScheduledTimeMs(0.0, 1.0));
            long blockedNanos = (long)(ThreadLocalRandom.current().nextDouble(0.97, 0.99) * (double)wallNanos);
            long perQuantaNanos = scheduledNanos / numQuanta;
            long betweenQuantaNanos = blockedNanos / numQuanta;
            return new SplitSpecification.IntermediateSplitSpecification(scheduledNanos, wallNanos, numQuanta, perQuantaNanos, betweenQuantaNanos, this.wakeupExecutor);
        }
    }

    static interface SplitGenerator {
        public SplitSpecification next();
    }
}

