/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogName;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.MockRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.RemoteTask;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.SqlStageExecution;
import io.trino.execution.StageId;
import io.trino.execution.TableInfo;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.DynamicSplitPlacementPolicy;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.execution.scheduler.SourcePartitionedScheduler;
import io.trino.execution.scheduler.SplitPlacementPolicy;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.execution.scheduler.StageScheduler;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.failuredetector.FailureDetector;
import io.trino.failuredetector.NoOpFailureDetector;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.operator.StageExecutionDescriptor;
import io.trino.server.DynamicFilterService;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.NotPartitionedPartitionHandle;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.split.ConnectorAwareSplitSource;
import io.trino.split.SplitSource;
import io.trino.sql.DynamicFilters;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.StageExecutionPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Expression;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingSplit;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.util.FinalizerService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSourcePartitionedScheduler {
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private static final CatalogName CONNECTOR_ID = TestingHandles.TEST_TABLE_HANDLE.getCatalogName();
    private static final QueryId QUERY_ID = new QueryId("query");
    private static final DynamicFilterId DYNAMIC_FILTER_ID = new DynamicFilterId("filter1");
    private final ExecutorService queryExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stageExecutor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"stageScheduledExecutor-%s"));
    private final InMemoryNodeManager nodeManager = new InMemoryNodeManager();
    private final FinalizerService finalizerService = new FinalizerService();
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final TypeOperators typeOperators = new TypeOperators();
    private final Session session = TestingSession.testSessionBuilder().build();

    public TestSourcePartitionedScheduler() {
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
    }

    @BeforeClass
    public void setUp() {
        this.finalizerService.start();
    }

    @AfterClass(alwaysRun=true)
    public void destroyExecutor() {
        this.queryExecutor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.finalizerService.destroy();
    }

    @Test
    public void testScheduleNoSplits() {
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(0, TestingSplit::createRemoteSplit));
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)1);
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
        stage.abort();
    }

    @Test
    public void testScheduleSplitsOneAtATime() {
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(60, TestingSplit::createRemoteSplit));
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        for (int i = 0; i < 60; ++i) {
            ScheduleResult scheduleResult = scheduler.schedule();
            if (i == 59) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i < 3 ? 1 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)(i < 3 ? i + 1 : 3));
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 1, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSplitsBatched() {
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(60, TestingSplit::createRemoteSplit));
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 7);
        for (int i = 0; i <= 8; ++i) {
            ScheduleResult scheduleResult = scheduler.schedule();
            if (i == 8) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i == 0 ? 3 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min((i + 1) * 7, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSplitsBlock() {
        ScheduleResult scheduleResult;
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(80, TestingSplit::createRemoteSplit));
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        for (int i = 0; i <= 60; ++i) {
            scheduleResult = scheduler.schedule();
            Assert.assertFalse((boolean)scheduleResult.isFinished());
            Assert.assertEquals((boolean)scheduleResult.getBlocked().isDone(), (i != 60 ? 1 : 0) != 0);
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i < 3 ? 1 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)(i < 3 ? i + 1 : 3));
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 1, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        ((MockRemoteTaskFactory.MockRemoteTask)stage.getAllTasks().get(0)).clearSplits();
        for (int i = 0; i < 20; ++i) {
            scheduleResult = scheduler.schedule();
            if (i == 19) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)0);
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 41, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSlowSplitSource() {
        QueuedSplitSource queuedSplitSource = new QueuedSplitSource(TestingSplit::createRemoteSplit);
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(queuedSplitSource);
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(plan, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertFalse((boolean)scheduleResult.isFinished());
        Assert.assertFalse((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)0);
        Assert.assertEquals((int)stage.getAllTasks().size(), (int)0);
        queuedSplitSource.addSplits(1);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
    }

    @Test
    public void testNoNodes() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> {
            NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
            InMemoryNodeManager nodeManager = new InMemoryNodeManager();
            NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap));
            StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(20, TestingSplit::createRemoteSplit));
            SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
            StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)((PlanNodeId)Iterables.getOnlyElement(plan.getSplitSources().keySet())), (SplitSource)((SplitSource)Iterables.getOnlyElement(plan.getSplitSources().values())), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(CONNECTOR_ID)), () -> ((SqlStageExecution)stage).getAllTasks()), (int)2, (DynamicFilterService)new DynamicFilterService(this.metadata, this.typeOperators, new DynamicFilterConfig()), () -> false);
            scheduler.schedule();
        }).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE);
    }

    @Test
    public void testBalancedSplitAssignment() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecutionPlan firstPlan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(15, TestingSplit::createRemoteSplit));
        SqlStageExecution firstStage = this.createSqlStageExecution(firstPlan, nodeTaskMap);
        StageScheduler firstScheduler = this.getSourcePartitionedScheduler(firstPlan, firstStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200);
        ScheduleResult scheduleResult = firstScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, firstScheduler);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)firstStage.getAllTasks().size(), (int)3);
        for (RemoteTask remoteTask : firstStage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)5);
        }
        InternalNode additionalNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{additionalNode});
        StageExecutionPlan secondPlan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(5, TestingSplit::createRemoteSplit));
        SqlStageExecution secondStage = this.createSqlStageExecution(secondPlan, nodeTaskMap);
        StageScheduler secondScheduler = this.getSourcePartitionedScheduler(secondPlan, secondStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200);
        scheduleResult = secondScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, secondScheduler);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)1);
        Assert.assertEquals((int)secondStage.getAllTasks().size(), (int)1);
        RemoteTask task = (RemoteTask)secondStage.getAllTasks().get(0);
        Assert.assertEquals((int)task.getPartitionedSplitCount(), (int)5);
        firstStage.abort();
        secondStage.abort();
    }

    @Test
    public void testNewTaskScheduledWhenChildStageBufferIsUnderutilized() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap, new Duration(0.0, TimeUnit.SECONDS)));
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(500, TestingSplit::createRemoteSplit));
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)((PlanNodeId)Iterables.getOnlyElement(plan.getSplitSources().keySet())), (SplitSource)((SplitSource)Iterables.getOnlyElement(plan.getSplitSources().values())), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(CONNECTOR_ID)), () -> ((SqlStageExecution)stage).getAllTasks()), (int)500, (DynamicFilterService)new DynamicFilterService(this.metadata, this.typeOperators, new DynamicFilterConfig()), () -> false);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertEquals(scheduleResult.getBlockedReason().get(), (Object)ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL);
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)scheduleResult.getSplitsScheduled(), (int)300);
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other4", URI.create("http://127.0.0.4:14"), NodeVersion.UNKNOWN, false)});
        scheduleResult = scheduler.schedule();
        Assert.assertEquals(scheduleResult.getBlockedReason().get(), (Object)ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL);
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)1);
        Assert.assertEquals((int)scheduleResult.getSplitsScheduled(), (int)100);
    }

    @Test
    public void testNoNewTaskScheduledWhenChildStageBufferIsOverutilized() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap, new Duration(0.0, TimeUnit.SECONDS)));
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createFixedSplitSource(400, TestingSplit::createRemoteSplit));
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)((PlanNodeId)Iterables.getOnlyElement(plan.getSplitSources().keySet())), (SplitSource)((SplitSource)Iterables.getOnlyElement(plan.getSplitSources().values())), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(CONNECTOR_ID)), () -> ((SqlStageExecution)stage).getAllTasks()), (int)400, (DynamicFilterService)new DynamicFilterService(this.metadata, this.typeOperators, new DynamicFilterConfig()), () -> true);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertEquals(scheduleResult.getBlockedReason().get(), (Object)ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL);
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)scheduleResult.getSplitsScheduled(), (int)300);
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other4", URI.create("http://127.0.0.4:14"), NodeVersion.UNKNOWN, false)});
        scheduleResult = scheduler.schedule();
        Assert.assertEquals(scheduleResult.getBlockedReason().get(), (Object)ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL);
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)0);
        Assert.assertEquals((int)scheduleResult.getSplitsScheduled(), (int)0);
    }

    @Test
    public void testDynamicFiltersUnblockedOnBlockedBuildSource() {
        StageExecutionPlan plan = TestSourcePartitionedScheduler.createPlan(TestSourcePartitionedScheduler.createBlockedSplitSource());
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)this.nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap));
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, new DynamicFilterConfig());
        dynamicFilterService.registerQuery(QUERY_ID, SessionTestUtils.TEST_SESSION, (Set)ImmutableSet.of((Object)DYNAMIC_FILTER_ID), (Set)ImmutableSet.of((Object)DYNAMIC_FILTER_ID), (Set)ImmutableSet.of((Object)DYNAMIC_FILTER_ID));
        StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)((PlanNodeId)Iterables.getOnlyElement(plan.getSplitSources().keySet())), (SplitSource)((SplitSource)Iterables.getOnlyElement(plan.getSplitSources().values())), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(CONNECTOR_ID)), () -> ((SqlStageExecution)stage).getAllTasks()), (int)2, (DynamicFilterService)dynamicFilterService, () -> true);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)BigintType.BIGINT);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(QUERY_ID, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(DYNAMIC_FILTER_ID, (Expression)symbol.toSymbolReference())), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assert.assertFalse((boolean)dynamicFilter.isBlocked().isDone());
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertTrue((boolean)dynamicFilter.isBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)1);
        Assert.assertEquals((int)scheduleResult.getSplitsScheduled(), (int)0);
    }

    private static void assertPartitionedSplitCount(SqlStageExecution stage, int expectedPartitionedSplitCount) {
        Assert.assertEquals((int)stage.getAllTasks().stream().mapToInt(RemoteTask::getPartitionedSplitCount).sum(), (int)expectedPartitionedSplitCount);
    }

    private static void assertEffectivelyFinished(ScheduleResult scheduleResult, StageScheduler scheduler) {
        if (scheduleResult.isFinished()) {
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            return;
        }
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        ScheduleResult nextScheduleResult = scheduler.schedule();
        Assert.assertTrue((boolean)nextScheduleResult.isFinished());
        Assert.assertTrue((boolean)nextScheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)nextScheduleResult.getNewTasks().size(), (int)0);
        Assert.assertEquals((int)nextScheduleResult.getSplitsScheduled(), (int)0);
    }

    private StageScheduler getSourcePartitionedScheduler(StageExecutionPlan plan, SqlStageExecution stage, InternalNodeManager nodeManager, NodeTaskMap nodeTaskMap, int splitBatchSize) {
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(false).setMaxSplitsPerNode(20).setMaxPendingSplitsPerTask(0);
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory(nodeManager, nodeSchedulerConfig, nodeTaskMap));
        PlanNodeId sourceNode = (PlanNodeId)Iterables.getOnlyElement(plan.getSplitSources().keySet());
        SplitSource splitSource = (SplitSource)Iterables.getOnlyElement(plan.getSplitSources().values());
        DynamicSplitPlacementPolicy placementPolicy = new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(splitSource.getCatalogName())), () -> ((SqlStageExecution)stage).getAllTasks());
        return SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)sourceNode, (SplitSource)splitSource, (SplitPlacementPolicy)placementPolicy, (int)splitBatchSize, (DynamicFilterService)new DynamicFilterService(this.metadata, this.typeOperators, new DynamicFilterConfig()), () -> false);
    }

    private static StageExecutionPlan createPlan(ConnectorSplitSource splitSource) {
        Symbol symbol = new Symbol("column");
        Symbol buildSymbol = new Symbol("buildColumn");
        PlanNodeId tableScanNodeId = new PlanNodeId("plan_id");
        TableScanNode tableScan = TableScanNode.newInstance((PlanNodeId)tableScanNodeId, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false, Optional.empty());
        FilterNode filterNode = new FilterNode(new PlanNodeId("filter_node_id"), (PlanNode)tableScan, DynamicFilters.createDynamicFilterExpression((Metadata)MetadataManager.createTestMetadataManager(), (DynamicFilterId)DYNAMIC_FILTER_ID, (Type)VarcharType.VARCHAR, (Expression)symbol.toSymbolReference()));
        RemoteSourceNode remote = new RemoteSourceNode(new PlanNodeId("remote_id"), new PlanFragmentId("plan_fragment_id"), (List)ImmutableList.of((Object)buildSymbol), Optional.empty(), ExchangeNode.Type.REPLICATE);
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId("plan_id"), (PlanNode)new JoinNode(new PlanNodeId("join_id"), JoinNode.Type.INNER, (PlanNode)filterNode, (PlanNode)remote, (List)ImmutableList.of(), tableScan.getOutputSymbols(), remote.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of((Object)DYNAMIC_FILTER_ID, (Object)buildSymbol), Optional.empty()), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)tableScanNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());
        return new StageExecutionPlan(testFragment, (Map)ImmutableMap.of((Object)tableScanNodeId, (Object)new ConnectorAwareSplitSource(CONNECTOR_ID, splitSource)), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)tableScanNodeId, (Object)new TableInfo(new QualifiedObjectName("test", "test", "test"), TupleDomain.all())));
    }

    private static ConnectorSplitSource createBlockedSplitSource() {
        return new ConnectorSplitSource(){

            public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
                return new CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch>();
            }

            public void close() {
            }

            public boolean isFinished() {
                return false;
            }
        };
    }

    private static ConnectorSplitSource createFixedSplitSource(int splitCount, Supplier<ConnectorSplit> splitFactory) {
        ImmutableList.Builder splits = ImmutableList.builder();
        for (int i = 0; i < splitCount; ++i) {
            splits.add((Object)splitFactory.get());
        }
        return new FixedSplitSource((Iterable)splits.build());
    }

    private SqlStageExecution createSqlStageExecution(StageExecutionPlan tableScanPlan, NodeTaskMap nodeTaskMap) {
        StageId stageId = new StageId(QUERY_ID, 0);
        SqlStageExecution stage = SqlStageExecution.createSqlStageExecution((StageId)stageId, (PlanFragment)tableScanPlan.getFragment(), (Map)tableScanPlan.getTables(), (RemoteTaskFactory)new MockRemoteTaskFactory(this.queryExecutor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (ExecutorService)this.queryExecutor, (FailureDetector)new NoOpFailureDetector(), (DynamicFilterService)new DynamicFilterService(this.metadata, this.typeOperators, new DynamicFilterConfig()), (SplitSchedulerStats)new SplitSchedulerStats());
        stage.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        return stage;
    }

    private static class QueuedSplitSource
    implements ConnectorSplitSource {
        private final Supplier<ConnectorSplit> splitFactory;
        private final LinkedBlockingQueue<ConnectorSplit> queue = new LinkedBlockingQueue();
        private CompletableFuture<?> notEmptyFuture = new CompletableFuture();
        private boolean closed;

        public QueuedSplitSource(Supplier<ConnectorSplit> splitFactory) {
            this.splitFactory = Objects.requireNonNull(splitFactory, "splitFactory is null");
        }

        synchronized void addSplits(int count) {
            if (this.closed) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                this.queue.add(this.splitFactory.get());
                this.notEmptyFuture.complete(null);
            }
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
            Preconditions.checkArgument((boolean)partitionHandle.equals((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED), (Object)"partitionHandle must be NOT_PARTITIONED");
            return ((CompletableFuture)this.notEmptyFuture.thenApply(x -> this.getBatch(maxSize))).thenApply(splits -> new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
        }

        private synchronized List<ConnectorSplit> getBatch(int maxSize) {
            ArrayList elements = new ArrayList(maxSize);
            this.queue.drainTo(elements, maxSize);
            if (this.queue.isEmpty() && !this.closed && this.notEmptyFuture.isDone()) {
                this.notEmptyFuture = new CompletableFuture();
            }
            return ImmutableList.copyOf(elements);
        }

        public synchronized boolean isFinished() {
            return this.closed && this.queue.isEmpty();
        }

        public synchronized void close() {
            this.closed = true;
        }
    }
}

