/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionListBuilder;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.Signature;
import io.trino.metadata.SignatureBuilder;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.CustomFunctions;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.UnknownType;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFunctionRegistry {
    @Test
    public void testIdentityCast() {
        BoundSignature exactOperator = MetadataManager.createTestMetadataManager().getCoercion((Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG).getSignature();
        Assert.assertEquals((Object)exactOperator, (Object)new BoundSignature(Signature.mangleOperatorName((OperatorType)OperatorType.CAST), (Type)HyperLogLogType.HYPER_LOG_LOG, (List)ImmutableList.of((Object)HyperLogLogType.HYPER_LOG_LOG)));
    }

    @Test
    public void testExactMatchBeforeCoercion() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        boolean foundOperator = false;
        for (FunctionMetadata function : TestFunctionRegistry.listOperators((Metadata)metadata)) {
            OperatorType operatorType = Signature.unmangleOperator((String)function.getSignature().getName());
            if (operatorType == OperatorType.CAST || operatorType == OperatorType.SATURATED_FLOOR_CAST || !function.getSignature().getTypeVariableConstraints().isEmpty() || function.getSignature().getArgumentTypes().stream().anyMatch(TypeSignature::isCalculated)) continue;
            List argumentTypes = (List)function.getSignature().getArgumentTypes().stream().map(arg_0 -> ((Metadata)metadata).getType(arg_0)).collect(ImmutableList.toImmutableList());
            BoundSignature exactOperator = metadata.resolveOperator(operatorType, argumentTypes).getSignature();
            Assert.assertEquals((Object)exactOperator.toSignature(), (Object)function.getSignature());
            foundOperator = true;
        }
        Assert.assertTrue((boolean)foundOperator);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="\\QFunction already registered: custom_add(bigint,bigint):bigint\\E")
    public void testDuplicateFunctions() {
        List functions = (List)new FunctionListBuilder().scalars(CustomFunctions.class).getFunctions().stream().filter(input -> input.getFunctionMetadata().getSignature().getName().equals("custom_add")).collect(ImmutableList.toImmutableList());
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        metadata.addFunctions(functions);
        metadata.addFunctions(functions);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="'sum' is both an aggregation and a scalar function")
    public void testConflictingScalarAggregation() {
        List functions = new FunctionListBuilder().scalars(ScalarSum.class).getFunctions();
        MetadataManager.createTestMetadataManager().addFunctions(functions);
    }

    @Test
    public void testResolveFunctionByExactMatch() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint")).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).returns(this.functionSignature("bigint", "bigint"));
    }

    @Test
    public void testResolveTypeParametrizedFunction() {
        TestFunctionRegistry.assertThatResolveFunction().among(TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"T", (Object)"T"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")))).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).returns(this.functionSignature("bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionWithCoercion() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "double"), this.functionSignature("decimal(p,s)", "decimal(p,s)"), this.functionSignature("double", "double")).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).returns(this.functionSignature("decimal(19,0)", "decimal(19,0)"));
    }

    @Test
    public void testAmbiguousCallWithNoCoercion() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "decimal(p,s)"), TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"T", (Object)"T"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")))).forParameters(new Type[]{DecimalType.createDecimalType((int)3, (int)1), DecimalType.createDecimalType((int)3, (int)1)}).returns(this.functionSignature("decimal(3,1)", "decimal(3,1)"));
    }

    @Test
    public void testAmbiguousCallWithCoercion() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "double"), this.functionSignature("double", "decimal(p,s)")).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).failsWithMessage("Could not choose a best candidate operator. Explicit type casts must be added.");
    }

    @Test
    public void testResolveFunctionWithCoercionInTypes() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("array(decimal(p,s))", "array(double)"), this.functionSignature("array(decimal(p,s))", "array(decimal(p,s))"), this.functionSignature("array(double)", "array(double)")).forParameters(new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)}).returns(this.functionSignature("array(decimal(19,0))", "array(decimal(19,0))"));
    }

    @Test
    public void testResolveFunctionWithVariableArity() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("double", "double", "double"), this.functionSignature("decimal(p,s)").setVariableArity(true)).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).returns(this.functionSignature("decimal(19,0)", "decimal(19,0)", "decimal(19,0)"));
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("double", "double", "double"), this.functionSignature("bigint").setVariableArity(true)).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).returns(this.functionSignature("bigint", "bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionWithVariadicBound() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint", "bigint"), TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"T1", (Object)"T2", (Object)"T3"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound((String)"T1", (String)"row"), (Object)Signature.withVariadicBound((String)"T2", (String)"row"), (Object)Signature.withVariadicBound((String)"T3", (String)"row")))).forParameters(new Type[]{UnknownType.UNKNOWN, BigintType.BIGINT, BigintType.BIGINT}).returns(this.functionSignature("bigint", "bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionForUnknown() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint")).forParameters(new Type[]{UnknownType.UNKNOWN}).returns(this.functionSignature("bigint"));
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint"), this.functionSignature("integer")).forParameters(new Type[]{UnknownType.UNKNOWN}).returns(this.functionSignature("integer"));
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint"), this.functionSignature("integer", "integer")).forParameters(new Type[]{UnknownType.UNKNOWN, BigintType.BIGINT}).returns(this.functionSignature("bigint", "bigint"));
        TestFunctionRegistry.assertThatResolveFunction().among(TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"JoniRegExp"), "boolean"), TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"integer"), "boolean")).forParameters(new Type[]{UnknownType.UNKNOWN}).returns(this.functionSignature("JoniRegExp"));
        TestFunctionRegistry.assertThatResolveFunction().among(TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"JoniRegExp"), "JoniRegExp"), TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"integer"), "integer")).forParameters(new Type[]{UnknownType.UNKNOWN}).failsWithMessage("Could not choose a best candidate operator. Explicit type casts must be added.");
    }

    private static List<FunctionMetadata> listOperators(Metadata metadata) {
        Set operatorNames = (Set)Arrays.stream(OperatorType.values()).map(Signature::mangleOperatorName).collect(ImmutableSet.toImmutableSet());
        return (List)metadata.listFunctions().stream().filter(function -> operatorNames.contains(function.getSignature().getName())).collect(ImmutableList.toImmutableList());
    }

    private SignatureBuilder functionSignature(String ... argumentTypes) {
        return TestFunctionRegistry.functionSignature((List<String>)ImmutableList.copyOf((Object[])argumentTypes), "boolean");
    }

    private static SignatureBuilder functionSignature(List<String> arguments, String returnType) {
        return TestFunctionRegistry.functionSignature(arguments, returnType, (List<TypeVariableConstraint>)ImmutableList.of());
    }

    private static SignatureBuilder functionSignature(List<String> arguments, String returnType, List<TypeVariableConstraint> typeVariableConstraints) {
        ImmutableSet literalParameters = ImmutableSet.of((Object)"p", (Object)"s", (Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2", (Object[])new String[]{"p3", "s3"});
        List argumentSignatures = (List)arguments.stream().map(signature -> TypeSignatureTranslator.parseTypeSignature((String)signature, (Set)literalParameters)).collect(ImmutableList.toImmutableList());
        return new SignatureBuilder().returnType(TypeSignatureTranslator.parseTypeSignature((String)returnType, (Set)literalParameters)).argumentTypes(argumentSignatures).typeVariableConstraints(typeVariableConstraints);
    }

    private static ResolveFunctionAssertion assertThatResolveFunction() {
        return new ResolveFunctionAssertion();
    }

    public static final class ScalarSum {
        private ScalarSum() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long sum(@SqlType(value="bigint") long a, @SqlType(value="bigint") long b) {
            return a + b;
        }
    }

    private static class ResolveFunctionAssertion {
        private static final String TEST_FUNCTION_NAME = "TEST_FUNCTION_NAME";
        private List<SignatureBuilder> functionSignatures = ImmutableList.of();
        private List<TypeSignature> parameterTypes = ImmutableList.of();

        private ResolveFunctionAssertion() {
        }

        public ResolveFunctionAssertion among(SignatureBuilder ... functionSignatures) {
            this.functionSignatures = ImmutableList.copyOf((Object[])functionSignatures);
            return this;
        }

        public ResolveFunctionAssertion forParameters(Type ... parameters) {
            this.parameterTypes = ResolveFunctionAssertion.parseTypeSignatures(parameters);
            return this;
        }

        public ResolveFunctionAssertion returns(SignatureBuilder functionSignature) {
            Signature expectedSignature = functionSignature.name(TEST_FUNCTION_NAME).build();
            Signature actualSignature = this.resolveSignature().toSignature();
            Assert.assertEquals((Object)actualSignature, (Object)expectedSignature);
            return this;
        }

        public ResolveFunctionAssertion failsWithMessage(String ... messages) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this::resolveSignature).isInstanceOf(RuntimeException.class)).hasMessageContainingAll((CharSequence[])messages);
            return this;
        }

        private BoundSignature resolveSignature() {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            metadata.addFunctions(this.createFunctionsFromSignatures());
            return metadata.resolveFunction(QualifiedName.of((String)TEST_FUNCTION_NAME), TypeSignatureProvider.fromTypeSignatures(this.parameterTypes)).getSignature();
        }

        private List<SqlFunction> createFunctionsFromSignatures() {
            ImmutableList.Builder functions = ImmutableList.builder();
            for (SignatureBuilder functionSignature : this.functionSignatures) {
                Signature signature = functionSignature.name(TEST_FUNCTION_NAME).build();
                FunctionMetadata functionMetadata = new FunctionMetadata(signature, false, Collections.nCopies(signature.getArgumentTypes().size(), new FunctionArgumentDefinition(false)), false, false, "testing function that does nothing", FunctionKind.SCALAR);
                functions.add((Object)new SqlScalarFunction(functionMetadata){

                    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
                        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(functionBinding.getArity(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), MethodHandles.identity(Void.class));
                    }
                });
            }
            return functions.build();
        }

        private static List<TypeSignature> parseTypeSignatures(Type ... signatures) {
            return ImmutableList.copyOf((Object[])signatures).stream().map(Type::getTypeSignature).collect(Collectors.toList());
        }
    }
}

