/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.PolymorphicScalarFunctionBuilder;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPolymorphicScalarFunction {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final Signature SIGNATURE = Signature.builder().name("foo").returnType(BigintType.BIGINT.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})}).build();
    private static final int INPUT_VARCHAR_LENGTH = 10;
    private static final Slice INPUT_SLICE = Slices.allocate((int)10);
    private static final BoundSignature BOUND_SIGNATURE = new BoundSignature(SIGNATURE.getName(), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)10)));
    private static final Map<String, Type> VARCHAR_TYPE_VARIABLES = ImmutableMap.of((Object)"V", (Object)VarcharType.createVarcharType((int)10));
    private static final Map<String, Long> VARCHAR_LONG_VARIABLES = ImmutableMap.of((Object)"x", (Object)10L);
    private static final TypeSignature DECIMAL_SIGNATURE = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"a_precision"), TypeSignatureParameter.typeVariable((String)"a_scale")});
    private static final DecimalType LONG_DECIMAL_BOUND_TYPE = DecimalType.createDecimalType((int)19, (int)2);
    private static final Map<String, Long> LONG_DECIMAL_LONG_VARIABLES = ImmutableMap.builder().put((Object)"a_precision", (Object)LONG_DECIMAL_BOUND_TYPE.getPrecision()).put((Object)"a_scale", (Object)LONG_DECIMAL_BOUND_TYPE.getScale()).build();
    private static final DecimalType SHORT_DECIMAL_BOUND_TYPE = DecimalType.createDecimalType((int)18, (int)2);
    private static final Map<String, Long> SHORT_DECIMAL_LONG_VARIABLES = ImmutableMap.builder().put((Object)"a_precision", (Object)SHORT_DECIMAL_BOUND_TYPE.getPrecision()).put((Object)"a_scale", (Object)SHORT_DECIMAL_BOUND_TYPE.getScale()).build();

    @Test
    public void testSelectsMultipleChoiceWithBlockPosition() throws Throwable {
        Signature signature = Signature.builder().operatorType(OperatorType.IS_DISTINCT_FROM).argumentTypes(new TypeSignature[]{DECIMAL_SIGNATURE, DECIMAL_SIGNATURE}).returnType(BooleanType.BOOLEAN.getTypeSignature()).build();
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(signature).argumentDefinitions(new FunctionArgumentDefinition[]{new FunctionArgumentDefinition(true), new FunctionArgumentDefinition(true)}).deterministic(true).choice(choice -> choice.argumentProperties(new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NULL_FLAG, InvocationConvention.InvocationArgumentConvention.NULL_FLAG}).implementation(methodsGroup -> methodsGroup.methods(new String[]{"shortShort", "longLong"}))).choice(choice -> choice.argumentProperties(new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}).implementation(methodsGroup -> methodsGroup.methodWithExplicitJavaTypes("blockPositionLongLong", Arrays.asList(Optional.of(Slice.class), Optional.of(Slice.class))).methodWithExplicitJavaTypes("blockPositionShortShort", Arrays.asList(Optional.of(Long.TYPE), Optional.of(Long.TYPE))))).build();
        FunctionBinding shortDecimalFunctionBinding = new FunctionBinding(function.getFunctionMetadata().getFunctionId(), new BoundSignature(signature.getName(), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)SHORT_DECIMAL_BOUND_TYPE, (Object)SHORT_DECIMAL_BOUND_TYPE)), (Map)ImmutableMap.of(), SHORT_DECIMAL_LONG_VARIABLES);
        ChoicesScalarFunctionImplementation functionImplementation = (ChoicesScalarFunctionImplementation)function.specialize(shortDecimalFunctionBinding, new FunctionDependencies(METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertEquals((int)functionImplementation.getChoices().size(), (int)2);
        Assert.assertEquals((Object)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getChoices().get(0)).getInvocationConvention(), (Object)new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG, (Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, false));
        Assert.assertEquals((Object)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getChoices().get(1)).getInvocationConvention(), (Object)new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, (Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, false));
        LongArrayBlock block1 = new LongArrayBlock(0, Optional.empty(), new long[0]);
        LongArrayBlock block2 = new LongArrayBlock(0, Optional.empty(), new long[0]);
        Assert.assertFalse((boolean)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getChoices().get(1)).getMethodHandle().invoke((Block)block1, 0, (Block)block2, 0));
        FunctionBinding longDecimalFunctionBinding = new FunctionBinding(function.getFunctionMetadata().getFunctionId(), new BoundSignature(signature.getName(), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)LONG_DECIMAL_BOUND_TYPE, (Object)LONG_DECIMAL_BOUND_TYPE)), (Map)ImmutableMap.of(), LONG_DECIMAL_LONG_VARIABLES);
        functionImplementation = (ChoicesScalarFunctionImplementation)function.specialize(longDecimalFunctionBinding, new FunctionDependencies(METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertTrue((boolean)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getChoices().get(1)).getMethodHandle().invoke((Block)block1, 0, (Block)block2, 0));
    }

    @Test
    public void testSelectsMethodBasedOnArgumentTypes() throws Throwable {
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)context.getLiteral("x"))))).build();
        FunctionBinding functionBinding = new FunctionBinding(function.getFunctionMetadata().getFunctionId(), BOUND_SIGNATURE, VARCHAR_TYPE_VARIABLES, VARCHAR_LONG_VARIABLES);
        ChoicesScalarFunctionImplementation functionImplementation = (ChoicesScalarFunctionImplementation)function.specialize(functionBinding, new FunctionDependencies(METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertEquals((Object)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getChoices().get(0)).getMethodHandle().invoke(INPUT_SLICE), (Object)10L);
    }

    @Test
    public void testSelectsMethodBasedOnReturnType() throws Throwable {
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarcharCreateSliceWithExtraParameterLength"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)42)))).build();
        FunctionBinding functionBinding = new FunctionBinding(function.getFunctionMetadata().getFunctionId(), BOUND_SIGNATURE, VARCHAR_TYPE_VARIABLES, VARCHAR_LONG_VARIABLES);
        ChoicesScalarFunctionImplementation functionImplementation = (ChoicesScalarFunctionImplementation)function.specialize(functionBinding, new FunctionDependencies(METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertEquals((Object)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getChoices().get(0)).getMethodHandle().invoke(INPUT_SLICE), (Object)42L);
    }

    @Test
    public void testSameLiteralInArgumentsAndReturnValue() throws Throwable {
        Signature signature = Signature.builder().name("foo").returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentTypes(new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})}).build();
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        FunctionBinding functionBinding = new FunctionBinding(function.getFunctionMetadata().getFunctionId(), new BoundSignature(signature.getName(), (Type)VarcharType.createVarcharType((int)10), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)10))), VARCHAR_TYPE_VARIABLES, VARCHAR_LONG_VARIABLES);
        ChoicesScalarFunctionImplementation functionImplementation = (ChoicesScalarFunctionImplementation)function.specialize(functionBinding, new FunctionDependencies(METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Slice slice = ((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getChoices().get(0)).getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testTypeParameters() throws Throwable {
        Signature signature = Signature.builder().name("foo").typeVariableConstraints(new TypeVariableConstraint[]{Signature.comparableWithVariadicBound((String)"V", (String)"ROW")}).returnType(new TypeSignature("V", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("V", new TypeSignatureParameter[0])}).build();
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        FunctionBinding functionBinding = new FunctionBinding(function.getFunctionMetadata().getFunctionId(), new BoundSignature(signature.getName(), (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR)), VARCHAR_TYPE_VARIABLES, VARCHAR_LONG_VARIABLES);
        ChoicesScalarFunctionImplementation functionImplementation = (ChoicesScalarFunctionImplementation)function.specialize(functionBinding, new FunctionDependencies(METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Slice slice = ((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getChoices().get(0)).getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testSetsHiddenToTrueForOperators() {
        Signature signature = Signature.builder().operatorType(OperatorType.ADD).returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentTypes(new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})}).build();
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        FunctionBinding functionBinding = new FunctionBinding(function.getFunctionMetadata().getFunctionId(), new BoundSignature(signature.getName(), (Type)VarcharType.createVarcharType((int)10), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)10))), VARCHAR_TYPE_VARIABLES, VARCHAR_LONG_VARIABLES);
        function.specialize(functionBinding, new FunctionDependencies(METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="method foo was not found in class io.trino.metadata.TestPolymorphicScalarFunction\\$TestMethods")
    public void testFailIfNotAllMethodsPresent() {
        new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"foo"}))).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="methods must be selected first")
    public void testFailNoMethodsAreSelectedWhenExtraParametersFunctionIsSet() {
        new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.withExtraParameters(context -> ImmutableList.of((Object)42)))).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="two matching methods \\(varcharToBigintReturnFirstExtraParameter and varcharToBigintReturnExtraParameter\\) for parameter types \\[varchar\\(10\\)\\]")
    public void testFailIfTwoMethodsWithSameArguments() {
        SqlScalarFunction function = new PolymorphicScalarFunctionBuilder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnFirstExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}))).build();
        FunctionBinding functionBinding = new FunctionBinding(function.getFunctionMetadata().getFunctionId(), BOUND_SIGNATURE, VARCHAR_TYPE_VARIABLES, VARCHAR_LONG_VARIABLES);
        function.specialize(functionBinding, new FunctionDependencies(METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
    }

    public static final class TestMethods {
        static final Slice VARCHAR_TO_VARCHAR_RETURN_VALUE = Slices.utf8Slice((String)"hello world");
        static final long VARCHAR_TO_BIGINT_RETURN_VALUE = 42L;

        public static Slice varcharToVarchar(Slice varchar) {
            return VARCHAR_TO_VARCHAR_RETURN_VALUE;
        }

        public static long varcharToBigint(Slice varchar) {
            return 42L;
        }

        public static long varcharToBigintReturnExtraParameter(Slice varchar, long extraParameter) {
            return extraParameter;
        }

        public static long bigintToBigintReturnExtraParameter(long bigint, int extraParameter) {
            return bigint;
        }

        public static long varcharToBigintReturnFirstExtraParameter(Slice varchar, long extraParameter1, int extraParameter2) {
            return extraParameter1;
        }

        public static Slice varcharToVarcharCreateSliceWithExtraParameterLength(Slice string, int extraParameter) {
            return Slices.allocate((int)extraParameter);
        }

        public static boolean blockPositionLongLong(Block left, int leftPosition, Block right, int rightPosition) {
            return true;
        }

        public static boolean blockPositionShortShort(Block left, int leftPosition, Block right, int rightPosition) {
            return false;
        }

        public static boolean shortShort(long left, boolean leftNull, long right, boolean rightNull) {
            return false;
        }

        public static boolean longLong(Slice left, boolean leftNull, Slice right, boolean rightNull) {
            return false;
        }
    }
}

