/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorFactory;
import io.trino.operator.TaskContext;
import io.trino.operator.unnest.UnnestOperator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=20, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=1000, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkUnnestOperator {
    private static final int TOTAL_POSITIONS = 10000;
    private static final String ARRAY_OF_VARCHAR = "array(varchar)";
    private static final String MAP_STRING_TO_STRING = "map(varchar,varchar)";
    private static final String ARRAY_OF_ROW_THREE_STRINGS = "array(row(varchar, varchar, varchar))";

    @Benchmark
    public List<Page> unnest(BenchmarkContext context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = context.getOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = context.getPages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (operator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    operator.addInput(inputPage);
                } else if (!finishing) {
                    operator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = operator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void testBlocks() {
        InputGenerator generator = new InputGenerator(0, 50, 50);
        Block block = generator.produceBlock((Type)new ArrayType((Type)VarcharType.VARCHAR), 100, 0.1, 0.1);
        Assert.assertEquals((int)block.getPositionCount(), (int)100);
        block = generator.produceBlock((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), 100, 0.1, 0.1);
        Assert.assertEquals((int)block.getPositionCount(), (int)100);
        block = generator.produceBlock((Type)RowType.anonymous(Arrays.asList(VarcharType.VARCHAR, VarcharType.VARCHAR)), 100, 0.1, 0.1);
        Assert.assertEquals((int)block.getPositionCount(), (int)100);
        block = generator.produceBlock((Type)new ArrayType((Type)RowType.anonymous(Arrays.asList(VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR))), 100, 0.1, 0.1);
        Assert.assertEquals((int)block.getPositionCount(), (int)100);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkUnnestOperator.class).withOptions(optionsBuilder -> optionsBuilder.addProfiler(GCProfiler.class)).run();
    }

    public static class InputGenerator {
        private static final int INT_UPPER_LIMIT = 1000000000;
        private static final String LETTERS = "abcdefghijklmnopqrstuvwxyz";
        private final Random random = new Random();
        private final int minNestedCardinality;
        private final int maxNestedCardinality;
        private final int maxStringLength;

        public InputGenerator(int minNestedCardinality, int maxNestedCardinality, int maxStringLength) {
            Preconditions.checkArgument((minNestedCardinality >= 0 ? 1 : 0) != 0, (Object)"minNestedCardinality must be >= 0");
            Preconditions.checkArgument((minNestedCardinality <= maxNestedCardinality ? 1 : 0) != 0, (Object)"minNestedCardinality must be <= maxNestedCardinality");
            Preconditions.checkArgument((maxStringLength >= 0 ? 1 : 0) != 0, (Object)"maxStringLength must be >= 0");
            this.minNestedCardinality = minNestedCardinality;
            this.maxNestedCardinality = maxNestedCardinality;
            this.maxStringLength = maxStringLength;
        }

        public Block produceBlock(Type type, int entries, double primitiveNullsRatio, double rowNullsRatio) {
            if (type instanceof ArrayType) {
                return this.produceArrayBlock((ArrayType)type, entries, primitiveNullsRatio, rowNullsRatio);
            }
            if (type instanceof MapType) {
                return this.produceMapBlock((MapType)type, entries, primitiveNullsRatio, rowNullsRatio);
            }
            if (type instanceof RowType) {
                return this.produceRowBlock((RowType)type, entries, primitiveNullsRatio, rowNullsRatio);
            }
            if (type == VarcharType.VARCHAR) {
                return this.produceStringBlock(entries, primitiveNullsRatio);
            }
            if (type == IntegerType.INTEGER) {
                return this.produceIntBlock(entries, primitiveNullsRatio);
            }
            throw new RuntimeException("not supported");
        }

        private Block produceStringBlock(int entries, double primitiveNullsRatio) {
            BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 100);
            for (int i = 0; i < entries; ++i) {
                if (this.random.nextDouble() <= primitiveNullsRatio) {
                    builder.appendNull();
                    continue;
                }
                VarcharType.VARCHAR.writeString(builder, InputGenerator.generateRandomString(this.random, this.random.nextInt(this.maxStringLength)));
            }
            return builder.build();
        }

        private Block produceIntBlock(int entries, double primitiveNullsRatio) {
            BlockBuilder builder = IntegerType.INTEGER.createBlockBuilder(null, 100);
            for (int i = 0; i < entries; ++i) {
                if (this.random.nextDouble() < primitiveNullsRatio) {
                    builder.appendNull();
                    continue;
                }
                IntegerType.INTEGER.writeLong(builder, (long)this.random.nextInt(1000000000));
            }
            return builder.build();
        }

        private Block produceArrayBlock(ArrayType arrayType, int entries, double primitiveNullsRatio, double rowNullsRatio) {
            BlockBuilder builder = arrayType.createBlockBuilder(null, 100);
            Type elementType = arrayType.getElementType();
            for (int i = 0; i < entries; ++i) {
                int arrayLength = this.minNestedCardinality + this.random.nextInt(this.maxNestedCardinality - this.minNestedCardinality);
                builder.appendStructure(this.produceBlock(elementType, arrayLength, primitiveNullsRatio, rowNullsRatio));
            }
            return builder.build();
        }

        private Block produceMapBlock(MapType mapType, int entries, double primitiveNullsRatio, double rowNullsRatio) {
            int[] mapLengths = new int[entries];
            int[] offsets = new int[entries + 1];
            int elementCount = 0;
            for (int i = 0; i < entries; ++i) {
                mapLengths[i] = this.minNestedCardinality + this.random.nextInt(this.maxNestedCardinality - this.minNestedCardinality);
                offsets[i + 1] = elementCount;
                elementCount += mapLengths[i];
            }
            Block keyBlock = this.produceBlock(mapType.getKeyType(), elementCount, 0.0, 0.0);
            Block valueBlock = this.produceBlock(mapType.getValueType(), elementCount, primitiveNullsRatio, rowNullsRatio);
            return mapType.createBlockFromKeyValue(Optional.empty(), offsets, keyBlock, valueBlock);
        }

        public Block produceRowBlock(RowType rowType, int entries, double primitiveNullsRatio, double rowNullsRatio) {
            boolean[] rowIsNull = new boolean[entries];
            int nonNullCount = 0;
            for (int i = 0; i < entries; ++i) {
                if (this.random.nextDouble() < rowNullsRatio) {
                    rowIsNull[i] = true;
                    continue;
                }
                rowIsNull[i] = false;
                ++nonNullCount;
            }
            int fieldCount = rowType.getTypeParameters().size();
            Block[] fieldBlocks = new Block[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                fieldBlocks[i] = this.produceBlock((Type)rowType.getTypeParameters().get(i), nonNullCount, primitiveNullsRatio, rowNullsRatio);
            }
            return RowBlock.fromFieldBlocks((int)entries, Optional.of(rowIsNull), (Block[])fieldBlocks);
        }

        public static String generateRandomString(Random random, int length) {
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                chars[i] = LETTERS.charAt(random.nextInt(LETTERS.length()));
            }
            return new String(chars);
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkContext {
        @Param(value={"varchar"})
        private String replicateType = "varchar";
        @Param(value={"array(varchar)", "map(varchar,varchar)", "array(row(varchar, varchar, varchar))"})
        private String nestedTypeOne = "array(row(varchar, varchar, varchar))";
        @Param(value={"NONE", "array(varchar)"})
        private String nestedTypeTwo = "NONE";
        @Param(value={"0.0", "0.2"})
        private double primitiveNullsRatioNestedOne;
        @Param(value={"0.0", "0.05"})
        private double rowNullsRatioNestedOne;
        @Param(value={"1000"})
        private int positionsPerPage = 1000;
        @Param(value={"50"})
        private int stringLengths = 50;
        @Param(value={"300"})
        private int nestedLengths = 300;
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        private List<Page> pages;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            InputGenerator inputGenerator = new InputGenerator(0, this.nestedLengths, this.stringLengths);
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            ImmutableList.Builder channelsBuilder = ImmutableList.builder();
            Type replicateType = this.getType((Metadata)metadata, this.replicateType).get();
            typesBuilder.add((Object)replicateType);
            channelsBuilder.add((Object)0);
            Type nestedTypeOne = this.getType((Metadata)metadata, this.nestedTypeOne).get();
            typesBuilder.add((Object)nestedTypeOne);
            channelsBuilder.add((Object)1);
            if (!this.nestedTypeTwo.equals("NONE")) {
                Type nestedTypeTwo = this.getType((Metadata)metadata, this.nestedTypeTwo).get();
                typesBuilder.add((Object)nestedTypeTwo);
                channelsBuilder.add((Object)2);
            }
            ImmutableList types = typesBuilder.build();
            ImmutableList channels = channelsBuilder.build();
            this.pages = BenchmarkContext.createInputPages(this.positionsPerPage, (List<Type>)typesBuilder.build(), inputGenerator, this.primitiveNullsRatioNestedOne, this.rowNullsRatioNestedOne);
            this.operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), channels.subList(0, 1), types.subList(0, 1), channels.subList(1, channels.size()), types.subList(1, types.size()), true, false);
        }

        public Optional<Type> getType(Metadata metadata, String typeString) {
            if (typeString.equals("NONE")) {
                return Optional.empty();
            }
            return Optional.of(metadata.fromSqlType(typeString));
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        public List<Page> getPages() {
            return this.pages;
        }

        private static List<Page> createInputPages(int positionsPerPage, List<Type> types, InputGenerator inputGenerator, double primitiveNullsRatioUnnest, double rowNullsRatioUnnest) {
            ImmutableList.Builder pages = ImmutableList.builder();
            int pageCount = 10000 / positionsPerPage;
            for (int i = 0; i < pageCount; ++i) {
                Block[] blocks = new Block[types.size()];
                blocks[0] = inputGenerator.produceBlock(types.get(0), positionsPerPage, 0.0, 0.0);
                blocks[1] = inputGenerator.produceBlock(types.get(1), positionsPerPage, primitiveNullsRatioUnnest, rowNullsRatioUnnest);
                if (blocks.length == 3) {
                    blocks[2] = inputGenerator.produceBlock(types.get(2), positionsPerPage, 0.0, 0.0);
                }
                pages.add((Object)new Page(blocks));
            }
            return pages.build();
        }
    }
}

