/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.testing.Assertions;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.GroupByHashYieldAssertion;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.RowNumberOperator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class TestRowNumberOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private final TypeOperators typeOperators = new TypeOperators();
    private final BlockTypeOperators blockTypeOperators = new BlockTypeOperators(this.typeOperators);
    private final JoinCompiler joinCompiler = new JoinCompiler(this.typeOperators);

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @DataProvider
    public Object[][] dataType() {
        return new Object[][]{{VarcharType.VARCHAR}, {BigintType.BIGINT}};
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    private DriverContext getDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @Test
    public void testRowNumberUnpartitioned() {
        DriverContext driverContext = this.getDriverContext();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.19).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).row(2L, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), 10, this.joinCompiler, this.blockTypeOperators);
        MaterializedResult expectedResult = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1L}).row(new Object[]{0.4, 1L}).row(new Object[]{0.5, 1L}).row(new Object[]{0.6, 1L}).row(new Object[]{0.2, 2L}).row(new Object[]{0.7, 2L}).row(new Object[]{0.8, 2L}).row(new Object[]{0.9, 2L}).row(new Object[]{0.1, 3L}).row(new Object[]{0.19, 3L}).build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assert.assertEquals((int)rowNumberColumn.getPositionCount(), (int)10);
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        Assertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expectedResult.getMaterializedRows());
    }

    @Test(dataProvider="dataType")
    public void testMemoryReservationYield(Type type) {
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys(type, 6000, 600);
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)type), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)type), Optional.empty(), Optional.empty(), 1, this.joinCompiler, this.blockTypeOperators);
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, type, (OperatorFactory)operatorFactory, operator -> ((RowNumberOperator)operator).getCapacity(), 1400000L);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(5));
        Assertions.assertGreaterThan((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x1400000L));
        int count = 0;
        for (Page page : result.getOutput()) {
            Assert.assertEquals((int)page.getChannelCount(), (int)3);
            for (int i = 0; i < page.getPositionCount(); ++i) {
                Assert.assertEquals((long)page.getBlock(2).getLong(i, 0), (long)1L);
                ++count;
            }
        }
        Assert.assertEquals((int)count, (int)3600000);
    }

    @Test(dataProvider="hashEnabledValues")
    public void testRowNumberPartitioned(boolean hashEnabled) {
        DriverContext driverContext = this.getDriverContext();
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, DoubleType.DOUBLE});
        List<Page> input = rowPagesBuilder.row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.19).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).row(2L, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.of(10), rowPagesBuilder.getHashChannel(), 10, this.joinCompiler, this.blockTypeOperators);
        MaterializedResult expectedPartition1 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1L}).row(new Object[]{0.4, 1L}).row(new Object[]{0.5, 1L}).row(new Object[]{0.6, 1L}).build();
        MaterializedResult expectedPartition2 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.2, 2L}).row(new Object[]{0.7, 2L}).row(new Object[]{0.8, 2L}).row(new Object[]{0.9, 2L}).build();
        MaterializedResult expectedPartition3 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.1, 3L}).row(new Object[]{0.19, 3L}).build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assert.assertEquals((int)rowNumberColumn.getPositionCount(), (int)10);
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
        ImmutableSet expectedPartition1Set = ImmutableSet.copyOf((Collection)expectedPartition1.getMaterializedRows());
        ImmutableSet expectedPartition2Set = ImmutableSet.copyOf((Collection)expectedPartition2.getMaterializedRows());
        ImmutableSet expectedPartition3Set = ImmutableSet.copyOf((Collection)expectedPartition3.getMaterializedRows());
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition1Set, (Set)actualSet).size(), (int)4);
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition2Set, (Set)actualSet).size(), (int)4);
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition3Set, (Set)actualSet).size(), (int)2);
    }

    @Test(dataProvider="hashEnabledValues")
    public void testRowNumberPartitionedLimit(boolean hashEnabled) {
        DriverContext driverContext = this.getDriverContext();
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, DoubleType.DOUBLE});
        List<Page> input = rowPagesBuilder.row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.19).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).row(2L, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.of(3), Optional.empty(), 10, this.joinCompiler, this.blockTypeOperators);
        MaterializedResult expectedPartition1 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1L}).row(new Object[]{0.4, 1L}).row(new Object[]{0.5, 1L}).row(new Object[]{0.6, 1L}).build();
        MaterializedResult expectedPartition2 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.2, 2L}).row(new Object[]{0.7, 2L}).row(new Object[]{0.8, 2L}).row(new Object[]{0.9, 2L}).build();
        MaterializedResult expectedPartition3 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.1, 3L}).row(new Object[]{0.19, 3L}).build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assert.assertEquals((int)rowNumberColumn.getPositionCount(), (int)8);
        for (int i = 0; i < rowNumberColumn.getPositionCount(); ++i) {
            Assert.assertTrue((rowNumberColumn.getLong(i, 0) <= 3L ? 1 : 0) != 0);
        }
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
        ImmutableSet expectedPartition1Set = ImmutableSet.copyOf((Collection)expectedPartition1.getMaterializedRows());
        ImmutableSet expectedPartition2Set = ImmutableSet.copyOf((Collection)expectedPartition2.getMaterializedRows());
        ImmutableSet expectedPartition3Set = ImmutableSet.copyOf((Collection)expectedPartition3.getMaterializedRows());
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition1Set, (Set)actualSet).size(), (int)3);
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition2Set, (Set)actualSet).size(), (int)3);
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition3Set, (Set)actualSet).size(), (int)2);
    }

    @Test
    public void testRowNumberUnpartitionedLimit() {
        DriverContext driverContext = this.getDriverContext();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.19).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).row(2L, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Optional.of(3), Optional.empty(), 10, this.joinCompiler, this.blockTypeOperators);
        MaterializedResult expectedRows = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{0.3, 1L}).row(new Object[]{0.2, 2L}).row(new Object[]{0.1, 3L}).row(new Object[]{0.19, 3L}).row(new Object[]{0.4, 1L}).row(new Object[]{0.5, 1L}).row(new Object[]{0.6, 1L}).row(new Object[]{0.7, 2L}).row(new Object[]{0.8, 2L}).row(new Object[]{0.9, 2L}).build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assert.assertEquals((int)rowNumberColumn.getPositionCount(), (int)3);
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)3);
        ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
        ImmutableSet expectedRowsSet = ImmutableSet.copyOf((Collection)expectedRows.getMaterializedRows());
        Assert.assertEquals((int)Sets.intersection((Set)expectedRowsSet, (Set)actualSet).size(), (int)3);
    }

    private static Block getRowNumberColumn(List<Page> pages) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, pages.size() * 100);
        for (Page page : pages) {
            int rowNumberChannel = page.getChannelCount() - 1;
            for (int i = 0; i < page.getPositionCount(); ++i) {
                BigintType.BIGINT.writeLong(builder, page.getBlock(rowNumberChannel).getLong(i, 0));
            }
        }
        return builder.build();
    }

    private static List<Page> stripRowNumberColumn(List<Page> input) {
        return (List)input.stream().map(page -> {
            Block[] blocks = new Block[page.getChannelCount() - 1];
            for (int i = 0; i < page.getChannelCount() - 1; ++i) {
                blocks[i] = page.getBlock(i);
            }
            return new Page(page.getPositionCount(), blocks);
        }).collect(ImmutableList.toImmutableList());
    }
}

