/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestAccumulatorCompiler {
    @Test
    public void testAccumulatorCompilerForTypeSpecificObjectParameter() {
        DynamicClassLoader classLoader = new DynamicClassLoader(TestAccumulatorCompiler.class.getClassLoader());
        TimestampType parameterType = TimestampType.TIMESTAMP_NANOS;
        Assertions.assertThat((Class)parameterType.getJavaType()).isEqualTo(LongTimestamp.class);
        Class<LongTimestampAggregation.State> stateInterface = LongTimestampAggregation.State.class;
        AccumulatorStateSerializer stateSerializer = StateCompiler.generateStateSerializer(stateInterface, (DynamicClassLoader)classLoader);
        AccumulatorStateFactory stateFactory = StateCompiler.generateStateFactory(stateInterface, (DynamicClassLoader)classLoader);
        MethodHandle inputFunction = Reflection.methodHandle(LongTimestampAggregation.class, (String)"input", (Class[])new Class[]{LongTimestampAggregation.State.class, LongTimestamp.class});
        MethodHandle combineFunction = Reflection.methodHandle(LongTimestampAggregation.class, (String)"combine", (Class[])new Class[]{LongTimestampAggregation.State.class, LongTimestampAggregation.State.class});
        MethodHandle outputFunction = Reflection.methodHandle(LongTimestampAggregation.class, (String)"output", (Class[])new Class[]{LongTimestampAggregation.State.class, BlockBuilder.class});
        AggregationMetadata metadata = new AggregationMetadata("longTimestampAggregation", (List)ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)parameterType)), inputFunction, Optional.empty(), combineFunction, outputFunction, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, stateFactory)), (Type)RealType.REAL);
        Assertions.assertThat((Object)AccumulatorCompiler.generateAccumulatorFactoryBinder((AggregationMetadata)metadata, (DynamicClassLoader)classLoader)).isNotNull();
    }

    public static class LongTimestampAggregation {
        public static void input(State state, LongTimestamp value) {
        }

        public static void combine(State stateA, State stateB) {
        }

        public static void output(State state, BlockBuilder blockBuilder) {
        }

        public static interface State
        extends AccumulatorState {
        }
    }
}

