/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import java.util.List;
import org.apache.commons.math3.stat.correlation.Covariance;

public class TestDoubleCovarianceSampAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createDoubleSequenceBlock(start + 5, start + 5 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "covar_samp";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length <= 1) {
            return null;
        }
        return new Covariance().covariance(AggregationTestUtils.constructDoublePrimitiveArray(start + 5, length), AggregationTestUtils.constructDoublePrimitiveArray(start, length), true);
    }
}

