/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.trino.metadata.MetadataManager;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRealHistogramAggregation {
    private final AccumulatorFactory factory;
    private final Page input;

    public TestRealHistogramAggregation() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        InternalAggregationFunction function = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"numeric_histogram"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE})));
        this.factory = function.bind((List)ImmutableList.of((Object)0, (Object)1, (Object)2), Optional.empty());
        this.input = TestRealHistogramAggregation.makeInput(10);
    }

    @Test
    public void test() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(this.input);
        Block expected = AggregationTestUtils.getFinalBlock(singleStep);
        Accumulator partialStep = this.factory.createAccumulator();
        partialStep.addInput(this.input);
        Block partialBlock = AggregationTestUtils.getIntermediateBlock(partialStep);
        Accumulator finalStep = this.factory.createAccumulator();
        finalStep.addIntermediate(partialBlock);
        Block actual = AggregationTestUtils.getFinalBlock(finalStep);
        Assert.assertEquals(TestRealHistogramAggregation.extractSingleValue(actual), TestRealHistogramAggregation.extractSingleValue(expected));
    }

    @Test
    public void testMerge() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(this.input);
        Block singleStepResult = AggregationTestUtils.getFinalBlock(singleStep);
        Accumulator partialStep = this.factory.createAccumulator();
        partialStep.addInput(this.input);
        Block intermediate = AggregationTestUtils.getIntermediateBlock(partialStep);
        Accumulator finalStep = this.factory.createAccumulator();
        finalStep.addIntermediate(intermediate);
        finalStep.addIntermediate(intermediate);
        Block actual = AggregationTestUtils.getFinalBlock(finalStep);
        Map expected = Maps.transformValues(TestRealHistogramAggregation.extractSingleValue(singleStepResult), value -> Float.valueOf(value.floatValue() * 2.0f));
        Assert.assertEquals(TestRealHistogramAggregation.extractSingleValue(actual), (Map)expected);
    }

    @Test
    public void testNull() {
        Accumulator accumulator = this.factory.createAccumulator();
        Block result = AggregationTestUtils.getFinalBlock(accumulator);
        Assert.assertTrue((result.getPositionCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.isNull(0));
    }

    @Test(expectedExceptions={TrinoException.class})
    public void testBadNumberOfBuckets() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(TestRealHistogramAggregation.makeInput(0));
        AggregationTestUtils.getFinalBlock(singleStep);
    }

    private static Map<Float, Float> extractSingleValue(Block block) {
        MapType mapType = StructuralTestUtil.mapType((Type)RealType.REAL, (Type)RealType.REAL);
        return (Map)mapType.getObjectValue(null, block, 0);
    }

    private static Page makeInput(int numberOfBuckets) {
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE));
        for (int i = 0; i < 100; ++i) {
            builder.declarePosition();
            BigintType.BIGINT.writeLong(builder.getBlockBuilder(0), (long)numberOfBuckets);
            RealType.REAL.writeLong(builder.getBlockBuilder(1), (long)i);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(2), 1.0);
        }
        return builder.build();
    }
}

