/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.groupby;

import com.google.common.base.Suppliers;
import com.google.common.primitives.Ints;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.groupby.AggregationTestOutput;
import io.trino.operator.aggregation.groupby.GroupByAggregationTestUtils;
import io.trino.spi.Page;
import java.util.Optional;
import java.util.function.Supplier;

public class AggregationTestInput {
    private final Page[] pages;
    private final InternalAggregationFunction function;
    private final int[] args;
    private final int offset;
    private final boolean isReversed;

    public AggregationTestInput(InternalAggregationFunction function, Page[] pages, int offset, boolean isReversed) {
        this.pages = pages;
        this.function = function;
        this.args = GroupByAggregationTestUtils.createArgs(function);
        this.offset = offset;
        this.isReversed = isReversed;
    }

    public void runPagesOnAccumulatorWithAssertion(long groupId, GroupedAccumulator groupedAccumulator, AggregationTestOutput expectedValue) {
        GroupedAccumulator accumulator = (GroupedAccumulator)Suppliers.ofInstance((Object)groupedAccumulator).get();
        for (Page page : this.getPages()) {
            accumulator.addInput(this.getGroupIdBlock(groupId, page), page);
        }
        expectedValue.validateAccumulator(accumulator, groupId);
    }

    public GroupedAccumulator runPagesOnAccumulator(long groupId, GroupedAccumulator groupedAccumulator) {
        return this.runPagesOnAccumulator(groupId, (Supplier<GroupedAccumulator>)Suppliers.ofInstance((Object)groupedAccumulator));
    }

    public GroupedAccumulator runPagesOnAccumulator(long groupId, Supplier<GroupedAccumulator> accumulatorSupplier) {
        GroupedAccumulator accumulator = accumulatorSupplier.get();
        for (Page page : this.getPages()) {
            accumulator.addInput(this.getGroupIdBlock(groupId, page), page);
        }
        return accumulator;
    }

    private GroupByIdBlock getGroupIdBlock(long groupId, Page page) {
        return AggregationTestUtils.createGroupByIdBlock((int)groupId, page.getPositionCount());
    }

    private Page[] getPages() {
        Page[] pages = this.pages;
        if (this.isReversed) {
            pages = AggregationTestUtils.reverseColumns(pages);
        }
        if (this.offset > 0) {
            pages = AggregationTestUtils.offsetColumns(pages, this.offset);
        }
        return pages;
    }

    public GroupedAccumulator createGroupedAccumulator() {
        return this.function.bind(Ints.asList((int[])this.args), Optional.empty()).createGroupedAccumulator();
    }
}

