/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.groupby;

import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.groupby.AggregationTestInput;
import io.trino.operator.aggregation.groupby.GroupByAggregationTestUtils;
import io.trino.spi.Page;
import io.trino.spi.block.Block;

public class AggregationTestInputBuilder {
    private final InternalAggregationFunction function;
    private int offset = -1;
    private boolean isRerversed;
    private Page[] pages;

    public AggregationTestInputBuilder(Block[] blocks, InternalAggregationFunction function) {
        this.pages = GroupByAggregationTestUtils.createPages(blocks);
        this.function = function;
    }

    public AggregationTestInputBuilder setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public AggregationTestInputBuilder setPages(Page[] pages) {
        this.pages = pages;
        return this;
    }

    public AggregationTestInputBuilder setRerversed(boolean rerversed) {
        this.isRerversed = rerversed;
        return this;
    }

    public AggregationTestInput build() {
        return new AggregationTestInput(this.function, this.pages, this.offset, this.isRerversed);
    }
}

