/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.MetadataManager;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.type.MapType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=15)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkDictionaryBlock {
    @Benchmark
    public long getSizeInBytes(BenchmarkData data) {
        return data.getDictionaryBlock().getSizeInBytes();
    }

    @Benchmark
    public Block copyPositions(BenchmarkData data) {
        int[] positionIds = data.getPositionsIds();
        return data.getAllPositionsDictionaryBlock().copyPositions(data.getPositionsIds(), 0, positionIds.length);
    }

    @Benchmark
    public Block copyPositionsCompactDictionary(BenchmarkData data) {
        int[] positionIds = data.getPositionsIds();
        return data.getAllPositionsCompactDictionaryBlock().copyPositions(data.getPositionsIds(), 0, positionIds.length);
    }

    @Test
    public void testGetSizeInBytes() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.getSizeInBytes(data);
    }

    @Test
    public void testCopyPositions() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.copyPositions(data);
    }

    @Test
    public void testCopyPositionsCompactDictionary() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.copyPositionsCompactDictionary(data);
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkDictionaryBlock().getSizeInBytes(data);
        Benchmarks.benchmark(BenchmarkDictionaryBlock.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int POSITIONS = 100000;
        @Param(value={"100", "1000", "10000", "100000"})
        private String selectedPositions = "100";
        private int[] positionsIds;
        private DictionaryBlock dictionaryBlock;
        private DictionaryBlock allPositionsDictionaryBlock;
        private DictionaryBlock allPositionsCompactDictionaryBlock;

        @Setup(value=Level.Invocation)
        public void setup() {
            this.positionsIds = BenchmarkData.generateIds(Integer.parseInt(this.selectedPositions), 100000);
            Block mapBlock = BenchmarkData.createMapBlock(100000);
            this.dictionaryBlock = new DictionaryBlock(mapBlock, this.positionsIds);
            int[] allPositions = IntStream.range(0, 100000).toArray();
            this.allPositionsDictionaryBlock = new DictionaryBlock(mapBlock, allPositions);
            this.allPositionsCompactDictionaryBlock = new DictionaryBlock(100000, mapBlock, allPositions, true);
        }

        private static Block createMapBlock(int positionCount) {
            MapType mapType = (MapType)MetadataManager.createTestMetadataManager().getType(new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.VARCHAR.getTypeSignature()), TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.VARCHAR.getTypeSignature())}));
            Block keyBlock = BenchmarkData.createDictionaryBlock(BenchmarkData.generateList("key", positionCount));
            Block valueBlock = BenchmarkData.createDictionaryBlock(BenchmarkData.generateList("value", positionCount));
            int[] offsets = new int[positionCount + 1];
            int mapSize = keyBlock.getPositionCount() / positionCount;
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = mapSize * i;
            }
            return mapType.createBlockFromKeyValue(Optional.empty(), offsets, keyBlock, valueBlock);
        }

        private static Block createDictionaryBlock(List<String> values) {
            Block dictionary = BenchmarkData.createSliceArrayBlock(values);
            int[] ids = new int[values.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = i;
            }
            return new DictionaryBlock(dictionary, ids);
        }

        private static Block createSliceArrayBlock(List<String> values) {
            Slice[] sliceArray = new Slice[values.size() + 1];
            for (int i = 0; i < values.size(); ++i) {
                sliceArray[i] = Slices.utf8Slice((String)values.get(i));
            }
            return BlockAssertions.createSlicesBlock(sliceArray);
        }

        private static List<String> generateList(String prefix, int count) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < count; ++i) {
                list.add((Object)(prefix + i));
            }
            return list.build();
        }

        private static int[] generateIds(int count, int range) {
            return new Random(42L).ints(count, 0, range).toArray();
        }

        public int[] getPositionsIds() {
            return this.positionsIds;
        }

        public DictionaryBlock getDictionaryBlock() {
            return this.dictionaryBlock;
        }

        public DictionaryBlock getAllPositionsDictionaryBlock() {
            return this.allPositionsDictionaryBlock;
        }

        public DictionaryBlock getAllPositionsCompactDictionaryBlock() {
            return this.allPositionsCompactDictionaryBlock;
        }
    }
}

