/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.jmh.Benchmarks;
import io.trino.operator.scalar.TypeOperatorBenchmarkUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=30, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=15, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayEqualOperator {
    private static final int POSITIONS = 10000;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public long equalOperator(BenchmarkData data) throws Throwable {
        return data.getEqualBlock().invokeExact(data.getLeftBlock(), data.getRightBlock());
    }

    @Test
    public void test() throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.equalOperator(data);
    }

    public static void main(String[] args) throws Throwable {
        Benchmarks.benchmark(BenchmarkArrayEqualOperator.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"BIGINT", "VARCHAR"})
        private String type = "BIGINT";
        @Param(value={"1", "10", "100", "1000"})
        private int arraySize = 10;
        private MethodHandle equalBlock;
        private Block leftBlock;
        private Block rightBlock;

        @Setup
        public void setup() {
            ArrayType arrayType = new ArrayType(TypeOperatorBenchmarkUtil.toType(this.type));
            Block[] channels = BenchmarkData.createChannels(10000, this.arraySize, arrayType);
            this.leftBlock = channels[0];
            this.rightBlock = channels[1];
            this.equalBlock = TypeOperatorBenchmarkUtil.getEqualBlockMethod((Type)arrayType);
        }

        private static Block[] createChannels(int positionCount, int arraySize, ArrayType arrayType) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            BlockBuilder leftBlockBuilder = arrayType.createBlockBuilder(null, positionCount);
            BlockBuilder rightBlockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder leftEntryBuilder = leftBlockBuilder.beginBlockEntry();
                BlockBuilder rightEntryBuilder = rightBlockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize - 1; ++i) {
                    TypeOperatorBenchmarkUtil.addElement(arrayType.getElementType(), random, leftEntryBuilder, rightEntryBuilder, true);
                }
                TypeOperatorBenchmarkUtil.addElement(arrayType.getElementType(), random, leftEntryBuilder, rightEntryBuilder, random.nextBoolean());
                leftBlockBuilder.closeEntry();
                rightBlockBuilder.closeEntry();
            }
            return new Block[]{leftBlockBuilder.build(), rightBlockBuilder.build()};
        }

        public MethodHandle getEqualBlock() {
            return this.equalBlock;
        }

        public Block getLeftBlock() {
            return this.leftBlock;
        }

        public Block getRightBlock() {
            return this.rightBlock;
        }
    }
}

