/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.operator.scalar.CustomFunctions;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCustomFunctions
extends AbstractTestFunctions {
    @BeforeClass
    public void setupClass() {
        this.registerScalar(CustomFunctions.class);
    }

    @Test
    public void testCustomAdd() {
        this.assertFunction("custom_add(123, 456)", (Type)BigintType.BIGINT, 579L);
    }

    @Test
    public void testSliceIsNull() {
        this.assertFunction("custom_is_null(CAST(NULL AS VARCHAR))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("custom_is_null('not null')", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLongIsNull() {
        this.assertFunction("custom_is_null(CAST(NULL AS BIGINT))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("custom_is_null(0)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIdentityFunction() {
        this.assertFunction("\"identity&function\"(\"identity.function\"(123))", (Type)BigintType.BIGINT, 123L);
        this.assertFunction("\"identity.function\"(\"identity&function\"(123))", (Type)BigintType.BIGINT, 123L);
    }
}

