/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionId;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParametricScalarImplementationValidation {
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"createState", (Class[])new Class[0]);

    @Test
    public void testConnectorSessionPosition() {
        MethodHandle validFunctionMethodHandle = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"validConnectorSessionParameterPosition", (Class[])new Class[]{ConnectorSession.class, Long.TYPE, Long.TYPE});
        ChoicesScalarFunctionImplementation validFunction = new ChoicesScalarFunctionImplementation(new FunctionBinding(new FunctionId("test"), new BoundSignature("test", (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), validFunctionMethodHandle);
        Assert.assertEquals((Object)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)validFunction.getChoices().get(0)).getMethodHandle(), (Object)validFunctionMethodHandle);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ChoicesScalarFunctionImplementation(new FunctionBinding(new FunctionId("test"), new BoundSignature("test", (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"invalidConnectorSessionParameterPosition", (Class[])new Class[]{Long.TYPE, Long.TYPE, ConnectorSession.class}))).isInstanceOf(IllegalArgumentException.class)).hasMessage("ConnectorSession must be the first argument when instanceFactory is not present");
        MethodHandle validFunctionWithInstanceFactoryMethodHandle = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"validConnectorSessionParameterPosition", (Class[])new Class[]{Object.class, ConnectorSession.class, Long.TYPE, Long.TYPE});
        ChoicesScalarFunctionImplementation validFunctionWithInstanceFactory = new ChoicesScalarFunctionImplementation(new FunctionBinding(new FunctionId("test"), new BoundSignature("test", (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), validFunctionWithInstanceFactoryMethodHandle, Optional.of(STATE_FACTORY));
        Assert.assertEquals((Object)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)validFunctionWithInstanceFactory.getChoices().get(0)).getMethodHandle(), (Object)validFunctionWithInstanceFactoryMethodHandle);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ChoicesScalarFunctionImplementation(new FunctionBinding(new FunctionId("test"), new BoundSignature("test", (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"invalidConnectorSessionParameterPosition", (Class[])new Class[]{Object.class, Long.TYPE, Long.TYPE, ConnectorSession.class}), Optional.of(STATE_FACTORY))).isInstanceOf(IllegalArgumentException.class)).hasMessage("ConnectorSession must be the second argument when instanceFactory is present");
    }

    public static Object createState() {
        return null;
    }

    public static long validConnectorSessionParameterPosition(ConnectorSession session, long arg1, long arg2) {
        return arg1 + arg2;
    }

    public static long validConnectorSessionParameterPosition(Object state, ConnectorSession session, long arg1, long arg2) {
        return arg1 + arg2;
    }

    public static long invalidConnectorSessionParameterPosition(long arg1, long arg2, ConnectorSession session) {
        return arg1 + arg2;
    }

    public static long invalidConnectorSessionParameterPosition(Object state, long arg1, long arg2, ConnectorSession session) {
        return arg1 + arg2;
    }
}

