/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDateTrunc {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testDateTruncYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.0 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.0000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.00000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.0000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.00000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.0000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.00000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-01-01 00:00:00.000000000000 Asia/Kathmandu'");
    }

    @Test
    public void testDateTruncQuarter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.0 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.0000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.00000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.0000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.00000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.0000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.00000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-04-01 00:00:00.000000000000 Asia/Kathmandu'");
    }

    @Test
    public void testDateTruncMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.0 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000000 Asia/Kathmandu'");
    }

    @Test
    public void testDateTruncWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.0 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.0000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.00000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.0000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.00000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.0000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.00000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-04 00:00:00.000000000000 Asia/Kathmandu'");
    }

    @Test
    public void testDateTruncDay() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.0 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.0000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.00000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.0000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.00000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.0000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.00000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 00:00:00.000000000000 Asia/Kathmandu'");
    }

    @Test
    public void testDateTruncHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.0 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.0000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.00000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.0000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.00000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.0000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.00000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:00:00.000000000000 Asia/Kathmandu'");
    }

    @Test
    public void testDateTruncMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.0 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.0000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.00000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.0000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.00000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.0000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.00000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:00.000000000000 Asia/Kathmandu'");
    }

    @Test
    public void testDateTruncSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.0 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.00 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.0000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.00000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.0000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.00000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.0000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.00000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000000000 Asia/Kathmandu'");
    }

    @Test
    public void testDateTruncMilliSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1230 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.12300 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1230000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.12300000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1230000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.12300000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123000000000 Asia/Kathmandu'");
    }
}

