/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.airlift.slice.Slice;
import io.trino.block.ColumnarTestUtils;
import io.trino.block.TestColumnarMap;
import io.trino.operator.unnest.MapUnnester;
import io.trino.operator.unnest.TestingUnnesterUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMapUnnester {
    @Test
    public void testSimple() {
        int[] unnestedLengths;
        int[] requiredOutputCounts = unnestedLengths = new int[]{1, 2, 0};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("0.0.0", "0.0.1")}), TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("1.0.0", "1.0.1"), TestingUnnesterUtil.toSlices("1.1.0", "1.1.1")), null);
        Block[] blocks = TestMapUnnester.testMapUnnester(unnestedLengths, requiredOutputCounts, elements);
        Assert.assertEquals((int)blocks.length, (int)2);
        Assert.assertTrue((boolean)(blocks[0] instanceof DictionaryBlock));
        Assert.assertTrue((boolean)(blocks[1] instanceof DictionaryBlock));
    }

    @Test
    public void testMisaligned() {
        int[] unnestedLengths = new int[]{1, 2, 0, 0};
        int[] requiredOutputCounts = new int[]{1, 3, 0, 1};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("0.0.0", "0.0.1")}), TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("1.0.0", "1.0.1"), TestingUnnesterUtil.toSlices("1.1.0", null)), null, null);
        Block[] blocks = TestMapUnnester.testMapUnnester(requiredOutputCounts, unnestedLengths, elements);
        Assert.assertEquals((int)blocks.length, (int)2);
        Assert.assertFalse((boolean)(blocks[0] instanceof DictionaryBlock));
        Assert.assertTrue((boolean)(blocks[1] instanceof DictionaryBlock));
    }

    private static Block[] testMapUnnester(int[] requiredOutputCounts, int[] unnestedLengths, Slice[][][] elements) {
        TestingUnnesterUtil.validateTestInput(requiredOutputCounts, unnestedLengths, elements, 2);
        int positionCount = unnestedLengths.length;
        for (int index = 0; index < positionCount; ++index) {
            if (elements[index] == null) continue;
            for (int i = 0; i < elements[index].length; ++i) {
                Assert.assertTrue((elements[index][i] != null ? 1 : 0) != 0, (String)"entry cannot be null");
                Assert.assertEquals((int)elements[index][i].length, (int)2);
            }
        }
        boolean[] nullsPresent = new boolean[]{TestingUnnesterUtil.nullExists(elements[0]), TestingUnnesterUtil.nullExists(elements[1])};
        Assert.assertFalse((boolean)nullsPresent[0]);
        MapUnnester mapUnnester = new MapUnnester((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        Block mapBlock = TestColumnarMap.createBlockBuilderWithValues(elements).build();
        Block[] blocks = null;
        for (int inputTestCount = 1; inputTestCount <= elements.length; ++inputTestCount) {
            PageBuilderStatus status = new PageBuilderStatus();
            mapUnnester.resetInput(mapBlock);
            Assert.assertEquals((int)mapUnnester.getInputEntryCount(), (int)elements.length);
            mapUnnester.startNewOutput(status, 10);
            boolean misAligned = false;
            for (int i = 0; i < inputTestCount; ++i) {
                int elementsSize;
                mapUnnester.processCurrentAndAdvance(requiredOutputCounts[i]);
                int n = elementsSize = elements[i] != null ? elements[i].length : 0;
                if (requiredOutputCounts[i] <= elementsSize) continue;
                misAligned = true;
            }
            blocks = mapUnnester.buildOutputBlocksAndFlush();
            Assert.assertEquals((int)blocks.length, (int)2);
            for (int field = 0; field < blocks.length; ++field) {
                Assert.assertTrue((blocks[field] instanceof DictionaryBlock || !nullsPresent[field] && misAligned ? 1 : 0) != 0);
                Assert.assertFalse((blocks[field] instanceof DictionaryBlock && !nullsPresent[field] && misAligned ? 1 : 0) != 0);
                Slice[][] fieldElements = TestingUnnesterUtil.getFieldElements(elements, field);
                Slice[] expectedOutput = TestingUnnesterUtil.computeExpectedUnnestedOutput(fieldElements, requiredOutputCounts, 0, inputTestCount);
                ColumnarTestUtils.assertBlock(blocks[field], expectedOutput);
            }
        }
        return blocks;
    }

    @Test
    public void testTrimmedBlocks() {
        int[] unnestedLengths = new int[]{1, 2, 1};
        Slice[][][] elements = TestingUnnesterUtil.column(TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("0.0.0", "0.0.1")}), TestingUnnesterUtil.array(TestingUnnesterUtil.toSlices("1.0.0", "1.0.1"), TestingUnnesterUtil.toSlices("1.1.0", "1.1.1")), TestingUnnesterUtil.array(new Slice[][]{TestingUnnesterUtil.toSlices("2.0.0", "2.0.1")}));
        Block mapBlock = TestColumnarMap.createBlockBuilderWithValues(elements).build();
        int startElement = 1;
        Slice[][][] truncatedSlices = (Slice[][][])Arrays.copyOfRange(elements, startElement, elements.length - startElement + 1);
        int[] truncatedUnnestedLengths = Arrays.copyOfRange(unnestedLengths, startElement, elements.length - startElement + 1);
        Block truncatedBlock = mapBlock.getRegion(startElement, elements.length - startElement);
        ColumnarTestUtils.assertBlock(truncatedBlock, truncatedSlices);
        MapUnnester mapUnnester = new MapUnnester((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        mapUnnester.resetInput(truncatedBlock);
        mapUnnester.startNewOutput(new PageBuilderStatus(), 20);
        for (int i = 0; i < truncatedBlock.getPositionCount(); ++i) {
            mapUnnester.processCurrentAndAdvance(truncatedUnnestedLengths[i]);
        }
        Block[] output = mapUnnester.buildOutputBlocksAndFlush();
        Assert.assertEquals((int)Arrays.asList(truncatedSlices).stream().mapToInt(slice -> ((Slice[][])slice).length).sum(), (int)output[0].getPositionCount());
        Slice[] expectedOutput0 = TestingUnnesterUtil.computeExpectedUnnestedOutput(TestingUnnesterUtil.getFieldElements(truncatedSlices, 0), truncatedUnnestedLengths, 0, truncatedSlices.length);
        ColumnarTestUtils.assertBlock(output[0], expectedOutput0);
        Slice[] expectedOutput1 = TestingUnnesterUtil.computeExpectedUnnestedOutput(TestingUnnesterUtil.getFieldElements(truncatedSlices, 1), truncatedUnnestedLengths, 0, truncatedSlices.length);
        ColumnarTestUtils.assertBlock(output[1], expectedOutput1);
    }
}

