/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.ColumnarTestUtils;
import io.trino.operator.unnest.ReplicatedBlockBuilder;
import io.trino.operator.unnest.TestingUnnesterUtil;
import io.trino.operator.unnest.UnnestOperatorBlockUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestReplicatedBlockBuilder {
    @Test
    public void testReplicateOutput() {
        String[] values = new String[]{"a", "b", "c", null, null, "e"};
        int[] count = new int[]{1, 0, 2, 2, 0, 3};
        TestReplicatedBlockBuilder.testReplication(TestingUnnesterUtil.toSlices(values), count);
    }

    @Test
    public void testReplicateEmptyOutput() {
        String[] values = new String[]{"a", null, "b"};
        int[] count = new int[]{0, 0, 0};
        TestReplicatedBlockBuilder.testReplication(TestingUnnesterUtil.toSlices(values), count);
    }

    private static void testReplication(Slice[] values, int[] counts) {
        Assert.assertEquals((int)values.length, (int)counts.length);
        ReplicatedBlockBuilder replicateBlockBuilder = new ReplicatedBlockBuilder();
        Block valuesBlock = TestingUnnesterUtil.createSimpleBlock(values);
        replicateBlockBuilder.resetInputBlock(valuesBlock);
        replicateBlockBuilder.startNewOutput(100);
        for (int i = 0; i < counts.length; ++i) {
            replicateBlockBuilder.appendRepeated(i, counts[i]);
        }
        Block outputBlock = replicateBlockBuilder.buildOutputAndFlush();
        ColumnarTestUtils.assertBlock(outputBlock, TestingUnnesterUtil.createReplicatedOutputSlice(values, counts));
        Assert.assertTrue((boolean)(outputBlock instanceof DictionaryBlock));
    }

    @Test
    public void testCapacityIncrease() {
        TestReplicatedBlockBuilder.assertSmallCapacityIncrease(4, 1, 4);
        TestReplicatedBlockBuilder.assertBigCapacityIncrease(50, 49, 100);
    }

    private static void assertSmallCapacityIncrease(int initialSize, int firstAppendCount, int secondAppendCount) {
        Assert.assertTrue((firstAppendCount <= initialSize ? 1 : 0) != 0);
        Assert.assertTrue((firstAppendCount + secondAppendCount > initialSize ? 1 : 0) != 0);
        Assert.assertTrue((firstAppendCount + secondAppendCount <= UnnestOperatorBlockUtil.calculateNewArraySize((int)initialSize) ? 1 : 0) != 0);
        TestReplicatedBlockBuilder.assertCapacityIncrease(initialSize, firstAppendCount, secondAppendCount, new ReplicatedBlockBuilder());
    }

    private static void assertBigCapacityIncrease(int initialSize, int firstAppendCount, int secondAppendCount) {
        Assert.assertTrue((firstAppendCount <= initialSize ? 1 : 0) != 0);
        Assert.assertTrue((firstAppendCount + secondAppendCount > initialSize ? 1 : 0) != 0);
        Assert.assertTrue((firstAppendCount + secondAppendCount > UnnestOperatorBlockUtil.calculateNewArraySize((int)initialSize) ? 1 : 0) != 0);
        TestReplicatedBlockBuilder.assertCapacityIncrease(initialSize, firstAppendCount, secondAppendCount, new ReplicatedBlockBuilder());
    }

    private static void assertCapacityIncrease(int initialSize, int firstAppendCount, int secondAppendCount, ReplicatedBlockBuilder replicatedBlockBuilder) {
        Slice[] values = new Slice[]{null, Slices.utf8Slice((String)"a")};
        Block inputBlock = TestingUnnesterUtil.createSimpleBlock(values);
        int repeatingIndex = 1;
        replicatedBlockBuilder.resetInputBlock(inputBlock);
        replicatedBlockBuilder.startNewOutput(initialSize);
        replicatedBlockBuilder.appendRepeated(repeatingIndex, firstAppendCount);
        replicatedBlockBuilder.appendRepeated(repeatingIndex, secondAppendCount);
        Block output = replicatedBlockBuilder.buildOutputAndFlush();
        int totalCount = firstAppendCount + secondAppendCount;
        ColumnarTestUtils.assertBlock(output, Collections.nCopies(totalCount, values[repeatingIndex]).toArray(new Slice[totalCount]));
    }
}

