/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.ColumnarTestUtils;
import io.trino.operator.unnest.TestingUnnesterUtil;
import io.trino.operator.unnest.UnnestBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUnnestBlockBuilder {
    @Test
    public void testWithNullElements() {
        TestUnnestBlockBuilder.testUnnestBlockBuilderMethods(new String[]{"a", "b", "c", null, "d", "e"});
    }

    @Test
    public void testWithoutNullElements() {
        TestUnnestBlockBuilder.testUnnestBlockBuilderMethods(new String[]{"a", "b", "c", "d", "e"});
    }

    @Test
    public void testCapacityIncrease() {
        Slice[] values = new Slice[100];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Slices.utf8Slice((String)"a");
        }
        UnnestBlockBuilder unnestBlockBuilder = new UnnestBlockBuilder((Type)VarcharType.VARCHAR);
        Block valuesBlock = TestingUnnesterUtil.createSimpleBlock(values);
        unnestBlockBuilder.resetInputBlock(valuesBlock);
        unnestBlockBuilder.startNewOutput(new PageBuilderStatus(), 20);
        unnestBlockBuilder.appendRange(0, values.length);
        ColumnarTestUtils.assertBlock(unnestBlockBuilder.buildOutputAndFlush(), values);
        unnestBlockBuilder.clearCurrentOutput();
    }

    @Test
    public void testEmptyOutput() {
        Slice[] values = TestingUnnesterUtil.toSlices("a", "b");
        UnnestBlockBuilder unnestBlockBuilder = new UnnestBlockBuilder((Type)VarcharType.VARCHAR);
        Block valuesBlock = TestingUnnesterUtil.createSimpleBlock(values);
        unnestBlockBuilder.resetInputBlock(valuesBlock);
        unnestBlockBuilder.startNewOutput(new PageBuilderStatus(), 10);
        Block block = unnestBlockBuilder.buildOutputAndFlush();
        Assert.assertTrue((boolean)(block instanceof DictionaryBlock));
        ColumnarTestUtils.assertBlock(block, new Slice[0]);
    }

    private static void testUnnestBlockBuilderMethods(String[] stringValues) {
        Slice[] values = TestingUnnesterUtil.toSlices(stringValues);
        UnnestBlockBuilder unnestBlockBuilder = new UnnestBlockBuilder((Type)VarcharType.VARCHAR);
        Block valuesBlock = TestingUnnesterUtil.createSimpleBlock(values);
        unnestBlockBuilder.resetInputBlock(valuesBlock);
        TestUnnestBlockBuilder.testAppendSingleElement(unnestBlockBuilder, values);
        TestUnnestBlockBuilder.testAppendRange(unnestBlockBuilder, values);
        TestUnnestBlockBuilder.testAppendNull(unnestBlockBuilder, values);
    }

    private static void testAppendSingleElement(UnnestBlockBuilder unnestBlockBuilder, Slice[] values) {
        for (int testCount = 1; testCount <= values.length; ++testCount) {
            unnestBlockBuilder.startNewOutput(new PageBuilderStatus(), 10);
            for (int i = 0; i < testCount; ++i) {
                unnestBlockBuilder.appendElement(i);
            }
            Block block = unnestBlockBuilder.buildOutputAndFlush();
            Assert.assertTrue((boolean)(block instanceof DictionaryBlock));
            ColumnarTestUtils.assertBlock(block, Arrays.copyOf(values, testCount));
        }
    }

    private static void testAppendRange(UnnestBlockBuilder unnestBlockBuilder, Slice[] values) {
        unnestBlockBuilder.startNewOutput(new PageBuilderStatus(), 10);
        Assert.assertTrue((values.length >= 3 ? 1 : 0) != 0, (String)"test requires at least 3 elements in values");
        int startIndex = 1;
        int length = values.length - 2;
        unnestBlockBuilder.appendRange(startIndex, length);
        Block block = unnestBlockBuilder.buildOutputAndFlush();
        Assert.assertTrue((boolean)(block instanceof DictionaryBlock));
        ColumnarTestUtils.assertBlock(block, Arrays.copyOfRange(values, startIndex, startIndex + length));
    }

    private static void testAppendNull(UnnestBlockBuilder unnestBlockBuilder, Slice[] values) {
        Assert.assertTrue((values.length >= 1 ? 1 : 0) != 0, (String)"values should have at least one element");
        int nullIndex = -1;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            nullIndex = i;
            break;
        }
        unnestBlockBuilder.startNewOutput(new PageBuilderStatus(), 10);
        unnestBlockBuilder.appendElement(0);
        Block block = unnestBlockBuilder.buildOutputAndFlush();
        Assert.assertTrue((boolean)(block instanceof DictionaryBlock));
        ColumnarTestUtils.assertBlock(block, new Slice[]{values[0]});
        unnestBlockBuilder.startNewOutput(new PageBuilderStatus(), 10);
        unnestBlockBuilder.appendElement(0);
        unnestBlockBuilder.appendNull();
        block = unnestBlockBuilder.buildOutputAndFlush();
        Assert.assertTrue((block instanceof DictionaryBlock || nullIndex == -1 ? 1 : 0) != 0);
        Assert.assertFalse((block instanceof DictionaryBlock && nullIndex == -1 ? 1 : 0) != 0);
        ColumnarTestUtils.assertBlock(block, new Slice[]{values[0], null});
        unnestBlockBuilder.startNewOutput(new PageBuilderStatus(), 10);
        unnestBlockBuilder.appendElement(0);
        unnestBlockBuilder.appendNull();
        unnestBlockBuilder.appendElement(0);
        block = unnestBlockBuilder.buildOutputAndFlush();
        Assert.assertTrue((block instanceof DictionaryBlock || nullIndex == -1 ? 1 : 0) != 0);
        Assert.assertFalse((block instanceof DictionaryBlock && nullIndex == -1 ? 1 : 0) != 0);
        ColumnarTestUtils.assertBlock(block, new Slice[]{values[0], null, values[0]});
    }
}

