/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.CatalogName;
import io.trino.connector.informationschema.InformationSchemaConnector;
import io.trino.connector.system.SystemConnector;
import io.trino.eventlistener.EventListenerManager;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.base.security.AllowAllAccessControl;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.security.SecurityContext;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.TestingConnectorContext;
import io.trino.testing.TestingEventListenerManager;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAccessControlManager {
    private static final Principal PRINCIPAL = new BasicPrincipal("principal");
    private static final String USER_NAME = "user_name";
    private static final QueryId queryId = new QueryId("query_id");

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp="Trino server is still initializing")
    public void testInitializing() {
        AccessControlManager accessControlManager = this.createAccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        accessControlManager.checkCanSetUser(Optional.empty(), "foo");
    }

    @Test
    public void testNoneSystemAccessControl() {
        AccessControlManager accessControlManager = this.createAccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        accessControlManager.setSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.empty(), USER_NAME);
    }

    @Test
    public void testReadOnlySystemAccessControl() {
        Identity identity = Identity.forUser((String)USER_NAME).withPrincipal(PRINCIPAL).build();
        QualifiedObjectName tableName = new QualifiedObjectName("catalog", "schema", "table");
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        accessControlManager.setSystemAccessControl("read-only", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.of(PRINCIPAL), USER_NAME);
        accessControlManager.checkCanSetSystemSessionProperty(identity, "property");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            SecurityContext context = new SecurityContext(transactionId, identity, queryId);
            accessControlManager.checkCanSetCatalogSessionProperty(context, "catalog", "property");
            accessControlManager.checkCanShowSchemas(context, "catalog");
            accessControlManager.checkCanShowTables(context, new CatalogSchemaName("catalog", "schema"));
            accessControlManager.checkCanSelectFromColumns(context, tableName, (Set)ImmutableSet.of((Object)"column"));
            accessControlManager.checkCanCreateViewWithSelectFromColumns(context, tableName, (Set)ImmutableSet.of((Object)"column"));
            accessControlManager.checkCanGrantExecuteFunctionPrivilege(context, "function", Identity.ofUser((String)"bob"), false);
            accessControlManager.checkCanGrantExecuteFunctionPrivilege(context, "function", Identity.ofUser((String)"bob"), true);
            ImmutableSet catalogs = ImmutableSet.of((Object)"catalog");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(identity, (Set)catalogs), (Set)catalogs);
            ImmutableSet schemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(context, "catalog", (Set)schemas), (Set)schemas);
            ImmutableSet tableNames = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assert.assertEquals((Set)accessControlManager.filterTables(context, "catalog", (Set)tableNames), (Set)tableNames);
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanInsertIntoTable(new SecurityContext(transactionId, identity, queryId), tableName))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table catalog.schema.table");
    }

    @Test
    public void testSetAccessControl() {
        AccessControlManager accessControlManager = this.createAccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.of(PRINCIPAL), USER_NAME);
        Assert.assertEquals((String)accessControlFactory.getCheckedUserName(), (String)USER_NAME);
        Assert.assertEquals(accessControlFactory.getCheckedPrincipal(), Optional.of(PRINCIPAL));
    }

    @Test
    public void testNoCatalogAccessControl() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(TestAccessControlManager.context(transactionId), new QualifiedObjectName("catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp="Access Denied: Cannot select from columns \\[column\\] in table or view schema.table")
    public void testDenyCatalogAccessControl() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        CatalogName catalogName = TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "catalog");
        accessControlManager.addCatalogAccessControl(catalogName, (ConnectorAccessControl)new DenyConnectorAccessControl());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(TestAccessControlManager.context(transactionId), new QualifiedObjectName("catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    @Test
    public void testColumnMaskOrdering() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        accessControlManager.addSystemAccessControlFactory(new SystemAccessControlFactory(){

            public String getName() {
                return "test";
            }

            public SystemAccessControl create(Map<String, String> config) {
                return new SystemAccessControl(){

                    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String column, Type type) {
                        return Optional.of(new ViewExpression("user", Optional.empty(), Optional.empty(), "system mask"));
                    }

                    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
                    }
                };
            }
        });
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        CatalogName catalogName = TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "catalog");
        accessControlManager.addCatalogAccessControl(catalogName, new ConnectorAccessControl(){

            public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String column, Type type) {
                return Optional.of(new ViewExpression("user", Optional.empty(), Optional.empty(), "connector mask"));
            }

            public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
            }
        });
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            List masks = accessControlManager.getColumnMasks(TestAccessControlManager.context(transactionId), new QualifiedObjectName("catalog", "schema", "table"), "column", (Type)BigintType.BIGINT);
            Assert.assertEquals((String)((ViewExpression)masks.get(0)).getExpression(), (String)"connector mask");
            Assert.assertEquals((String)((ViewExpression)masks.get(1)).getExpression(), (String)"system mask");
        });
    }

    private static SecurityContext context(TransactionId transactionId) {
        Identity identity = Identity.forUser((String)USER_NAME).withPrincipal(PRINCIPAL).build();
        return new SecurityContext(transactionId, identity, queryId);
    }

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp="Access Denied: Cannot select from table secured_catalog.schema.table")
    public void testDenySystemAccessControl() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "connector");
        accessControlManager.addCatalogAccessControl(new CatalogName("connector"), (ConnectorAccessControl)new DenyConnectorAccessControl());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(TestAccessControlManager.context(transactionId), new QualifiedObjectName("secured_catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    @Test
    public void testDenyExecuteProcedureBySystem() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("deny-all");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("deny-all", (Map)ImmutableMap.of());
        this.assertDenyExecuteProcedure(transactionManager, accessControlManager, "Access Denied: Cannot execute procedure connector.schema.procedure");
    }

    @Test
    public void testDenyExecuteProcedureByConnector() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        accessControlManager.setSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "connector");
        accessControlManager.addCatalogAccessControl(new CatalogName("connector"), (ConnectorAccessControl)new DenyConnectorAccessControl());
        this.assertDenyExecuteProcedure(transactionManager, accessControlManager, "Access Denied: Cannot execute procedure schema.procedure");
    }

    @Test
    public void testAllowExecuteProcedure() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        accessControlManager.setSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "connector");
        accessControlManager.addCatalogAccessControl(new CatalogName("connector"), (ConnectorAccessControl)new AllowAllAccessControl());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanExecuteProcedure(TestAccessControlManager.context(transactionId), new QualifiedObjectName("connector", "schema", "procedure")));
    }

    @Test
    public void testRegisterSingleEventListener() throws IOException {
        EventListener expectedListener = new EventListener(){};
        String systemAccessControlName = "event-listening-sac";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = this.createAccessControlManager(eventListenerManager, (List<String>)ImmutableList.of((Object)("access-control.name=" + systemAccessControlName)));
        accessControlManager.addSystemAccessControlFactory(this.eventListeningSystemAccessControlFactory(systemAccessControlName, expectedListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Iterable)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{expectedListener});
    }

    @Test
    public void testRegisterMultipleEventListeners() throws IOException {
        EventListener firstListener = new EventListener(){};
        EventListener secondListener = new EventListener(){};
        String systemAccessControlName = "event-listening-sac";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = this.createAccessControlManager(eventListenerManager, (List<String>)ImmutableList.of((Object)("access-control.name=" + systemAccessControlName)));
        accessControlManager.addSystemAccessControlFactory(this.eventListeningSystemAccessControlFactory(systemAccessControlName, firstListener, secondListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Iterable)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{firstListener, secondListener});
    }

    private void assertDenyExecuteProcedure(TransactionManager transactionManager, AccessControlManager accessControlManager, String s) {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanExecuteProcedure(TestAccessControlManager.context(transactionId), new QualifiedObjectName("connector", "schema", "procedure"))).isInstanceOf(AccessDeniedException.class)).hasMessage(s));
    }

    private static CatalogName registerBogusConnector(CatalogManager catalogManager, TransactionManager transactionManager, AccessControl accessControl, String catalogName) {
        CatalogName catalog = new CatalogName(catalogName);
        Connector connector = new TpchConnectorFactory().create(catalogName, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        MetadataManager metadata = MetadataManager.createTestMetadataManager((CatalogManager)catalogManager);
        CatalogName systemId = CatalogName.createSystemTablesCatalogName((CatalogName)catalog);
        catalogManager.registerCatalog(new Catalog(catalogName, catalog, connector, CatalogName.createInformationSchemaCatalogName((CatalogName)catalog), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, (Metadata)metadata, accessControl), systemId, (Connector)new SystemConnector((InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> transactionManager.getConnectorTransaction(transactionId, catalog))));
        return catalog;
    }

    @Test
    public void testDenyExecuteFunctionBySystemAccessControl() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("deny-all");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("deny-all", (Map)ImmutableMap.of());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanExecuteFunction(TestAccessControlManager.context(transactionId), "executed_function")).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot execute function executed_function");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanGrantExecuteFunctionPrivilege(TestAccessControlManager.context(transactionId), "executed_function", Identity.ofUser((String)"bob"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: 'user_name' cannot grant 'executed_function' execution to user 'bob'");
        });
    }

    @Test
    public void testAllowExecuteFunction() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        accessControlManager.setSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanExecuteFunction(TestAccessControlManager.context(transactionId), "executed_function");
            accessControlManager.checkCanGrantExecuteFunctionPrivilege(TestAccessControlManager.context(transactionId), "executed_function", Identity.ofUser((String)"bob"), true);
        });
    }

    private AccessControlManager createAccessControlManager(TestingEventListenerManager eventListenerManager, List<String> systemAccessControlProperties) throws IOException {
        Path systemAccessControlConfig = Files.createTempFile("access-control-config-file", ".properties", new FileAttribute[0]);
        Files.write(systemAccessControlConfig, systemAccessControlProperties, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        String accessControlConfigPath = systemAccessControlConfig.toFile().getAbsolutePath();
        return this.createAccessControlManager((EventListenerManager)eventListenerManager, new AccessControlConfig().setAccessControlFiles(accessControlConfigPath));
    }

    private AccessControlManager createAccessControlManager(TransactionManager testTransactionManager) {
        return new AccessControlManager(testTransactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig());
    }

    private AccessControlManager createAccessControlManager(EventListenerManager eventListenerManager, AccessControlConfig config) {
        return new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), eventListenerManager, config);
    }

    private SystemAccessControlFactory eventListeningSystemAccessControlFactory(final String name, final EventListener ... eventListeners) {
        return new SystemAccessControlFactory(){

            public String getName() {
                return name;
            }

            public SystemAccessControl create(Map<String, String> config) {
                return new SystemAccessControl(){

                    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
                    }

                    public Iterable<EventListener> getEventListeners() {
                        return ImmutableSet.copyOf((Object[])eventListeners);
                    }
                };
            }
        };
    }

    private static class DenyConnectorAccessControl
    implements ConnectorAccessControl {
        private DenyConnectorAccessControl() {
        }
    }

    private static class TestSystemAccessControlFactory
    implements SystemAccessControlFactory {
        private final String name;
        private Map<String, String> config;
        private Optional<Principal> checkedPrincipal;
        private String checkedUserName;

        public TestSystemAccessControlFactory(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public Optional<Principal> getCheckedPrincipal() {
            return this.checkedPrincipal;
        }

        public String getCheckedUserName() {
            return this.checkedUserName;
        }

        public String getName() {
            return this.name;
        }

        public SystemAccessControl create(Map<String, String> config) {
            this.config = config;
            return new SystemAccessControl(){

                public void checkCanSetUser(Optional<Principal> principal, String userName) {
                    checkedPrincipal = principal;
                    checkedUserName = userName;
                }

                public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
                }

                public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
                    throw new UnsupportedOperationException();
                }

                public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
                    if (table.getCatalogName().equals("secured_catalog")) {
                        AccessDeniedException.denySelectTable((String)table.toString());
                    }
                }

                public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
                    return catalogs;
                }
            };
        }
    }
}

