/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.airlift.jaxrs.testing.GuavaMultivaluedMap;
import io.trino.client.ProtocolHeaders;
import io.trino.server.HttpRequestSessionContext;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpRequestSessionContext {
    @Test
    public void testSessionContext() {
        TestHttpRequestSessionContext.assertSessionContext(ProtocolHeaders.TRINO_HEADERS);
        TestHttpRequestSessionContext.assertSessionContext(ProtocolHeaders.createProtocolHeaders((String)"taco"));
    }

    private static void assertSessionContext(ProtocolHeaders protocolHeaders) {
        GuavaMultivaluedMap headers = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)protocolHeaders.requestUser(), (Object)"testUser").put((Object)protocolHeaders.requestSource(), (Object)"testSource").put((Object)protocolHeaders.requestCatalog(), (Object)"testCatalog").put((Object)protocolHeaders.requestSchema(), (Object)"testSchema").put((Object)protocolHeaders.requestPath(), (Object)"testPath").put((Object)protocolHeaders.requestLanguage(), (Object)"zh-TW").put((Object)protocolHeaders.requestTimeZone(), (Object)"Asia/Taipei").put((Object)protocolHeaders.requestClientInfo(), (Object)"client-info").put((Object)protocolHeaders.requestSession(), (Object)"query_max_memory=1GB").put((Object)protocolHeaders.requestSession(), (Object)"join_distribution_type=partitioned,hash_partition_count = 43").put((Object)protocolHeaders.requestSession(), (Object)"some_session_property=some value with %2C comma").put((Object)protocolHeaders.requestPreparedStatement(), (Object)"query1=select * from foo,query2=select * from bar").put((Object)protocolHeaders.requestRole(), (Object)"foo_connector=ALL").put((Object)protocolHeaders.requestRole(), (Object)"bar_connector=NONE").put((Object)protocolHeaders.requestRole(), (Object)"foobar_connector=ROLE{role}").put((Object)protocolHeaders.requestExtraCredential(), (Object)"test.token.foo=bar").put((Object)protocolHeaders.requestExtraCredential(), (Object)"test.token.abc=xyz").build());
        HttpRequestSessionContext context = new HttpRequestSessionContext((MultivaluedMap)headers, Optional.of(protocolHeaders.getProtocolName()), "testRemote", Optional.empty(), ImmutableSet::of);
        Assert.assertEquals((String)context.getSource(), (String)"testSource");
        Assert.assertEquals((String)context.getCatalog(), (String)"testCatalog");
        Assert.assertEquals((String)context.getSchema(), (String)"testSchema");
        Assert.assertEquals((String)context.getPath(), (String)"testPath");
        Assert.assertEquals((Object)context.getIdentity(), (Object)Identity.ofUser((String)"testUser"));
        Assert.assertEquals((String)context.getClientInfo(), (String)"client-info");
        Assert.assertEquals((String)context.getLanguage(), (String)"zh-TW");
        Assert.assertEquals((String)context.getTimeZoneId(), (String)"Asia/Taipei");
        Assert.assertEquals((Map)context.getSystemProperties(), (Map)ImmutableMap.of((Object)"query_max_memory", (Object)"1GB", (Object)"join_distribution_type", (Object)"partitioned", (Object)"hash_partition_count", (Object)"43", (Object)"some_session_property", (Object)"some value with , comma"));
        Assert.assertEquals((Map)context.getPreparedStatements(), (Map)ImmutableMap.of((Object)"query1", (Object)"select * from foo", (Object)"query2", (Object)"select * from bar"));
        Assert.assertEquals((Map)context.getIdentity().getRoles(), (Map)ImmutableMap.of((Object)"foo_connector", (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty()), (Object)"bar_connector", (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty()), (Object)"foobar_connector", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role"))));
        Assert.assertEquals((Map)context.getIdentity().getExtraCredentials(), (Map)ImmutableMap.of((Object)"test.token.foo", (Object)"bar", (Object)"test.token.abc", (Object)"xyz"));
        Assert.assertEquals((Set)context.getIdentity().getGroups(), (Set)ImmutableSet.of((Object)"testUser"));
    }

    @Test
    public void testMappedUser() {
        TestHttpRequestSessionContext.assertMappedUser(ProtocolHeaders.TRINO_HEADERS);
        TestHttpRequestSessionContext.assertMappedUser(ProtocolHeaders.createProtocolHeaders((String)"taco"));
    }

    private static void assertMappedUser(ProtocolHeaders protocolHeaders) {
        GuavaMultivaluedMap userHeaders = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.of((Object)protocolHeaders.requestUser(), (Object)"testUser"));
        MultivaluedHashMap emptyHeaders = new MultivaluedHashMap();
        HttpRequestSessionContext context = new HttpRequestSessionContext((MultivaluedMap)userHeaders, Optional.of(protocolHeaders.getProtocolName()), "testRemote", Optional.empty(), ImmutableSet::of);
        Assert.assertEquals((Object)context.getIdentity(), (Object)Identity.forUser((String)"testUser").withGroups((Set)ImmutableSet.of((Object)"testUser")).build());
        context = new HttpRequestSessionContext((MultivaluedMap)emptyHeaders, Optional.of(protocolHeaders.getProtocolName()), "testRemote", Optional.of(Identity.forUser((String)"mappedUser").withGroups((Set)ImmutableSet.of((Object)"test")).build()), ImmutableSet::of);
        Assert.assertEquals((Object)context.getIdentity(), (Object)Identity.forUser((String)"mappedUser").withGroups((Set)ImmutableSet.of((Object)"test", (Object)"mappedUser")).build());
        context = new HttpRequestSessionContext((MultivaluedMap)userHeaders, Optional.of(protocolHeaders.getProtocolName()), "testRemote", Optional.of(Identity.ofUser((String)"mappedUser")), ImmutableSet::of);
        Assert.assertEquals((Object)context.getIdentity(), (Object)Identity.forUser((String)"testUser").withGroups((Set)ImmutableSet.of((Object)"testUser")).build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestHttpRequestSessionContext.lambda$assertMappedUser$1((MultivaluedMap)emptyHeaders, protocolHeaders)).isInstanceOf(WebApplicationException.class)).matches(e -> ((WebApplicationException)e).getResponse().getStatus() == 400);
    }

    @Test
    public void testPreparedStatementsHeaderDoesNotParse() {
        TestHttpRequestSessionContext.assertPreparedStatementsHeaderDoesNotParse(ProtocolHeaders.TRINO_HEADERS);
        TestHttpRequestSessionContext.assertPreparedStatementsHeaderDoesNotParse(ProtocolHeaders.createProtocolHeaders((String)"taco"));
    }

    private static void assertPreparedStatementsHeaderDoesNotParse(ProtocolHeaders protocolHeaders) {
        GuavaMultivaluedMap headers = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)protocolHeaders.requestUser(), (Object)"testUser").put((Object)protocolHeaders.requestSource(), (Object)"testSource").put((Object)protocolHeaders.requestCatalog(), (Object)"testCatalog").put((Object)protocolHeaders.requestSchema(), (Object)"testSchema").put((Object)protocolHeaders.requestPath(), (Object)"testPath").put((Object)protocolHeaders.requestLanguage(), (Object)"zh-TW").put((Object)protocolHeaders.requestTimeZone(), (Object)"Asia/Taipei").put((Object)protocolHeaders.requestClientInfo(), (Object)"null").put((Object)protocolHeaders.requestPreparedStatement(), (Object)"query1=abcdefg").build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestHttpRequestSessionContext.lambda$assertPreparedStatementsHeaderDoesNotParse$4((MultivaluedMap)headers, protocolHeaders)).isInstanceOf(WebApplicationException.class)).hasMessageMatching("Invalid " + protocolHeaders.requestPreparedStatement() + " header: line 1:1: mismatched input 'abcdefg'. Expecting: .*");
    }

    private static /* synthetic */ void lambda$assertPreparedStatementsHeaderDoesNotParse$4(MultivaluedMap headers, ProtocolHeaders protocolHeaders) throws Throwable {
        new HttpRequestSessionContext(headers, Optional.of(protocolHeaders.getProtocolName()), "testRemote", Optional.empty(), user -> ImmutableSet.of());
    }

    private static /* synthetic */ void lambda$assertMappedUser$1(MultivaluedMap emptyHeaders, ProtocolHeaders protocolHeaders) throws Throwable {
        new HttpRequestSessionContext(emptyHeaders, Optional.of(protocolHeaders.getProtocolName()), "testRemote", Optional.empty(), user -> ImmutableSet.of());
    }
}

