/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableMap;
import io.airlift.node.NodeInfo;
import io.trino.Session;
import io.trino.metadata.SessionPropertyManager;
import io.trino.server.SessionPropertyDefaults;
import io.trino.spi.QueryId;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.Identity;
import io.trino.spi.session.SessionPropertyConfigurationManagerFactory;
import io.trino.spi.session.TestingSessionPropertyConfigurationManagerFactory;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSessionPropertyDefaults {
    private static final ResourceGroupId TEST_RESOURCE_GROUP_ID = new ResourceGroupId("test");
    private static final NodeInfo TEST_NODE_INFO = new NodeInfo("test");

    @Test
    public void testApplyDefaultProperties() {
        SessionPropertyDefaults sessionPropertyDefaults = new SessionPropertyDefaults(TEST_NODE_INFO);
        TestingSessionPropertyConfigurationManagerFactory factory = new TestingSessionPropertyConfigurationManagerFactory((Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"override").put((Object)"system_default", (Object)"system_default").build(), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"override").put((Object)"catalog_default", (Object)"catalog_default").build()));
        sessionPropertyDefaults.addConfigurationManagerFactory((SessionPropertyConfigurationManagerFactory)factory);
        sessionPropertyDefaults.setConfigurationManager(factory.getName(), (Map)ImmutableMap.of());
        Session session = Session.builder((SessionPropertyManager)new SessionPropertyManager()).setQueryId(new QueryId("test_query_id")).setIdentity(Identity.ofUser((String)"testUser")).setSystemProperty("query_max_memory", "1GB").setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("hash_partition_count", "43").setCatalogSessionProperty("testCatalog", "explicit_set", "explicit_set").build();
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").build());
        Assert.assertEquals((Map)session.getUnprocessedCatalogProperties(), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"explicit_set").build()));
        session = sessionPropertyDefaults.newSessionWithDefaultProperties(session, Optional.empty(), TEST_RESOURCE_GROUP_ID);
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").put((Object)"system_default", (Object)"system_default").build());
        Assert.assertEquals((Map)session.getUnprocessedCatalogProperties(), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"explicit_set").put((Object)"catalog_default", (Object)"catalog_default").build()));
    }
}

