/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.inject.Binder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.node.NodeInfo;
import io.airlift.security.pem.PemReader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.trino.client.OkHttpUtil;
import io.trino.client.ProtocolHeaders;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.security.AccessControlManager;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.PasswordAuthenticator;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.testing.assertions.Assert;
import java.io.File;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class TestResourceSecurity {
    private static final String LOCALHOST_KEYSTORE = Resources.getResource((String)"cert/localhost.pem").getPath();
    private static final String ALLOWED_USER_MAPPING_PATTERN = "(.*)@allowed";
    private static final ImmutableMap<String, String> SECURE_PROPERTIES = ImmutableMap.builder().put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.process-forwarded", (Object)"true").put((Object)"http-server.authentication.insecure.user-mapping.pattern", (Object)"(.*)@allowed").build();
    private static final String TEST_USER = "test-user";
    private static final String TEST_USER_LOGIN = "test-user@allowed";
    private static final String TEST_PASSWORD = "test-password";
    private static final String TEST_PASSWORD2 = "test-password-2";
    private static final String MANAGEMENT_USER = "management-user";
    private static final String MANAGEMENT_USER_LOGIN = "management-user@allowed";
    private static final String MANAGEMENT_PASSWORD = "management-password";
    private static final String HMAC_KEY = Resources.getResource((String)"hmac_key.txt").getPath();
    private static final PrivateKey JWK_PRIVATE_KEY;
    private static final ObjectMapper json;
    private OkHttpClient client;
    private Path passwordConfigDummy;

    @BeforeClass
    public void setup() throws IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(false);
        OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty());
        this.client = clientBuilder.build();
        this.passwordConfigDummy = Files.createTempFile("passwordConfigDummy", "", new FileAttribute[0]);
        this.passwordConfigDummy.toFile().deleteOnExit();
    }

    @Test
    public void testInsecureAuthenticatorHttp() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"http-server.authentication.insecure.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).build()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
        }
    }

    @Test
    public void testInsecureAuthenticatorHttps() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties(SECURE_PROPERTIES).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
            this.assertInsecureAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testInsecureAuthenticatorHttpsOnly() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"false").build()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            this.assertInsecureAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testPasswordAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testMultiplePasswordAuthenticators() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate, TestResourceSecurity::authenticate2});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri(), TEST_PASSWORD, TEST_PASSWORD2);
        }
    }

    @Test
    public void testMultiplePasswordAuthenticatorsMessages() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate, TestResourceSecurity::authenticate2});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            Request request = new Request.Builder().url(TestResourceSecurity.getAuthorizedUserLocation(httpServerInfo.getHttpsUri())).headers(Headers.of((String[])new String[]{"Authorization", Credentials.basic((String)TEST_USER_LOGIN, (String)"wrong_password")})).build();
            try (Response response = this.client.newCall(request).execute();){
                Assertions.assertThat((String)response.message()).isEqualTo("Access Denied: Invalid credentials | Access Denied: Invalid credentials2");
            }
        }
    }

    @Test
    public void testPasswordAuthenticatorWithInsecureHttp() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttpInsecureEnabledOnly() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).put((Object)"management.user", (Object)MANAGEMENT_USER).build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertFixedManagementUser(httpServerInfo.getHttpUri(), true);
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttpInsecureDisabledOnly() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"false").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).put((Object)"management.user", (Object)MANAGEMENT_USER).build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getPublicLocation(httpServerInfo.getHttpUri()), 200);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(httpServerInfo.getHttpUri()), 403, TEST_USER_LOGIN, null);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(httpServerInfo.getHttpUri()), 200);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(httpServerInfo.getHttpUri()), 200, "unknown", "something");
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttps() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"management.user", (Object)MANAGEMENT_USER).put((Object)"management.user.https-enabled", (Object)"true").build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertFixedManagementUser(httpServerInfo.getHttpUri(), true);
            this.assertFixedManagementUser(httpServerInfo.getHttpsUri(), false);
        }
    }

    @Test
    public void testCertAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"certificate").put((Object)"http-server.https.truststore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.truststore.key", (Object)"").build()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            OkHttpClient.Builder clientBuilder = this.client.newBuilder();
            OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty());
            OkHttpClient clientWithCert = clientBuilder.build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithCert);
        }
    }

    @Test
    public void testJwtAuthenticator() throws Exception {
        this.verifyJwtAuthenticator(Optional.empty());
        this.verifyJwtAuthenticator(Optional.of("custom-principal"));
    }

    private void verifyJwtAuthenticator(Optional<String> principalField) throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)HMAC_KEY).put((Object)"http-server.authentication.jwt.principal-field", (Object)principalField.orElse("sub")).build()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            String hmac = Files.readString(Paths.get(HMAC_KEY, new String[0]));
            JwtBuilder tokenBuilder = Jwts.builder().signWith(SignatureAlgorithm.HS256, hmac).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant()));
            if (principalField.isPresent()) {
                tokenBuilder.claim(principalField.get(), (Object)TEST_USER);
            } else {
                tokenBuilder.setSubject(TEST_USER);
            }
            String token = tokenBuilder.compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithJwt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJwtWithJwkAuthenticator() throws Exception {
        TestingHttpServer jwkServer = TestResourceSecurity.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)jwkServer.getBaseUrl().toString()).build()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            String token = Jwts.builder().signWith(SignatureAlgorithm.RS256, (Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)"test-rsa").setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithJwt);
        }
        finally {
            jwkServer.stop();
        }
    }

    @Test
    public void testOAuth2Authenticator() throws Exception {
        this.verifyOAuth2Authenticator(true, Optional.empty());
        this.verifyOAuth2Authenticator(false, Optional.empty());
        this.verifyOAuth2Authenticator(true, Optional.of("custom-principal"));
        this.verifyOAuth2Authenticator(false, Optional.of("custom-principal"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOAuth2Authenticator(boolean webUiEnabled, Optional<String> principalField) throws Exception {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        Date tokenExpiration = Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant());
        JwtBuilder tokenBuilder = Jwts.builder().signWith(SignatureAlgorithm.RS256, (Key)JWK_PRIVATE_KEY).setAudience("trino_oauth_rest").setHeaderParam("kid", (Object)"test-rsa").setExpiration(tokenExpiration);
        if (principalField.isPresent()) {
            tokenBuilder.claim(principalField.get(), (Object)TEST_USER);
        } else {
            tokenBuilder.setSubject(TEST_USER);
        }
        final String token = tokenBuilder.compact();
        TestingHttpServer jwkServer = TestResourceSecurity.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"oauth2").put((Object)"web-ui.enabled", (Object)String.valueOf(webUiEnabled)).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.state-key", (Object)"test-state-key").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.token-url", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.client-id", (Object)"client").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"client-secret").put((Object)"http-server.authentication.oauth2.principal-field", (Object)principalField.orElse("sub")).build()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)new OAuth2Client(){

            public URI getAuthorizationUri(String state, URI callbackUri, Optional<String> nonceHash) {
                return URI.create("http://example.com/authorize?" + state);
            }

            public OAuth2Client.AccessToken getAccessToken(String code, URI callbackUri) {
                if (!"TEST_CODE".equals(code)) {
                    throw new IllegalArgumentException("Expected TEST_CODE");
                }
                return new OAuth2Client.AccessToken(token, Optional.empty(), Optional.empty());
            }
        })).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)new TestSystemAccessControl());
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            URI baseUri = httpServerInfo.getHttpsUri();
            TestResourceSecurity.assertOk(client, TestResourceSecurity.getPublicLocation(baseUri));
            OAuthBearer bearer = TestResourceSecurity.assertAuthenticateOAuth2Bearer(client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), "http://example.com/authorize");
            TestResourceSecurity.assertAuthenticateOAuth2Bearer(client, TestResourceSecurity.getManagementLocation(baseUri), "http://example.com/authorize");
            TestResourceSecurity.assertResponseCode(client, TestResourceSecurity.getInternalLocation(baseUri), 403);
            TestResourceSecurity.assertOk(client, HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath("/oauth2/callback/").addParameter("code", new String[]{"TEST_CODE"}).addParameter("state", new String[]{bearer.getState()}).toString());
            Assert.assertEquals((String)TestResourceSecurity.getOauthToken(client, bearer.getTokenServer()), (String)token);
            if (webUiEnabled) {
                HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
                Assert.assertEquals((String)cookie.getValue(), (String)token);
                Assert.assertEquals((String)cookie.getPath(), (String)"/ui/");
                Assert.assertEquals((String)cookie.getDomain(), (String)baseUri.getHost());
                org.testng.Assert.assertTrue((cookie.getMaxAge() > 0L && cookie.getMaxAge() < TimeUnit.MINUTES.toSeconds(5L) ? 1 : 0) != 0);
                org.testng.Assert.assertTrue((boolean)cookie.isHttpOnly());
                cookieManager.getCookieStore().removeAll();
            } else {
                List<HttpCookie> cookies = cookieManager.getCookieStore().getCookies();
                org.testng.Assert.assertTrue((boolean)cookies.isEmpty(), (String)("Expected no cookies when webUi is not enabled, but got: " + cookies));
            }
            OkHttpClient clientWithOAuthToken = client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithOAuthToken);
        }
        finally {
            jwkServer.stop();
        }
    }

    private static OAuthBearer assertAuthenticateOAuth2Bearer(OkHttpClient client, String url, String expectedRedirect) throws IOException {
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)401, (String)url);
            String authenticateHeader = response.header("WWW-Authenticate");
            org.testng.Assert.assertNotNull((Object)authenticateHeader);
            Pattern oauth2BearerPattern = Pattern.compile(String.format("Bearer x_redirect_server=\"%s\\?(.+)\", x_token_server=\"(https://127.0.0.1:[0-9]+/oauth2/token/.+)\"", expectedRedirect));
            Matcher matcher = oauth2BearerPattern.matcher(authenticateHeader);
            org.testng.Assert.assertTrue((boolean)matcher.matches(), (String)String.format("Invalid authentication header.\nExpected: %s\nPattern: %s", authenticateHeader, oauth2BearerPattern));
            OAuthBearer oAuthBearer = new OAuthBearer(matcher.group(1), matcher.group(2));
            return oAuthBearer;
        }
    }

    private static String getOauthToken(OkHttpClient client, String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            String body = Objects.requireNonNull(response.body()).string();
            String string = ((TokenDTO)TestResourceSecurity.json.readValue((String)body, TokenDTO.class)).token;
            return string;
        }
    }

    private void assertInsecureAuthentication(URI baseUri) throws IOException {
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, MANAGEMENT_USER_LOGIN, null);
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, TEST_USER_LOGIN, "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, TEST_USER_LOGIN, "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, MANAGEMENT_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER_LOGIN, "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER_LOGIN, MANAGEMENT_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, MANAGEMENT_USER_LOGIN, null);
    }

    private void assertPasswordAuthentication(URI baseUri) throws IOException {
        this.assertPasswordAuthentication(baseUri, TEST_PASSWORD);
    }

    private void assertPasswordAuthentication(URI baseUri, String ... allowedPasswords) throws IOException {
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, TEST_USER_LOGIN, "invalid");
        for (String password : allowedPasswords) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER_LOGIN, password);
        }
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, TEST_USER_LOGIN, "invalid");
        for (String password : allowedPasswords) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, TEST_USER_LOGIN, password);
        }
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER_LOGIN, "invalid");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, MANAGEMENT_USER_LOGIN, MANAGEMENT_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        for (String password : allowedPasswords) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, TEST_USER_LOGIN, password);
        }
    }

    private static void assertAuthenticationAutomatic(URI baseUri, OkHttpClient authorizedClient) throws IOException {
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getPublicLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getManagementLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getManagementLocation(baseUri), 200, Headers.of((String[])new String[]{ProtocolHeaders.TRINO_HEADERS.requestUser(), MANAGEMENT_USER}));
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getInternalLocation(baseUri), 403);
    }

    private void assertAuthenticationDisabled(URI baseUri) throws IOException {
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, TEST_USER_LOGIN, TEST_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, TEST_USER_LOGIN, TEST_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, TEST_USER_LOGIN, TEST_PASSWORD);
    }

    private void assertFixedManagementUser(URI baseUri, boolean insecureAuthentication) throws IOException {
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getPublicLocation(baseUri), 200);
        if (insecureAuthentication) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER_LOGIN, null);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, "unknown", null);
        } else {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER_LOGIN, TEST_PASSWORD);
        }
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, "unknown", "something");
    }

    private static void assertOk(OkHttpClient client, String url) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, 200, null, null);
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, expectedCode, null, null);
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode, String userName, String password) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, expectedCode, Headers.of((String[])new String[]{"Authorization", Credentials.basic((String)((String)MoreObjects.firstNonNull((Object)userName, (Object)"")), (String)((String)MoreObjects.firstNonNull((Object)password, (Object)"")))}));
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode, Headers headers) throws IOException {
        Request request = new Request.Builder().url(url).headers(headers).build();
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)expectedCode, (String)url);
        }
    }

    private static String getInternalLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/task");
    }

    private static String getManagementLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/node");
    }

    private static String getAuthorizedUserLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/query");
    }

    private static String getPublicLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/info");
    }

    private static String getLocation(URI baseUri, String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).toString();
    }

    private static Principal authenticate(String user, String password) {
        if (TEST_USER_LOGIN.equals(user) && TEST_PASSWORD.equals(password) || MANAGEMENT_USER_LOGIN.equals(user) && MANAGEMENT_PASSWORD.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    private static Principal authenticate2(String user, String password) {
        if (TEST_USER_LOGIN.equals(user) && TEST_PASSWORD2.equals(password) || MANAGEMENT_USER_LOGIN.equals(user) && MANAGEMENT_PASSWORD.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials2");
    }

    private static TestingHttpServer createTestingJwkServer() throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)new JwkServlet(), (Map)ImmutableMap.of());
    }

    static {
        json = new ObjectMapper();
        try {
            JWK_PRIVATE_KEY = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-private.pem").getPath()), Optional.empty());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class TokenDTO {
        @JsonProperty
        String token;

        private TokenDTO() {
        }
    }

    private static class JwkServlet
    extends HttpServlet {
        private JwkServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
            response.getWriter().println(jwkKeys);
        }
    }

    private static class TestSystemAccessControl
    extends AllowAllSystemAccessControl {
        private TestSystemAccessControl() {
        }

        public void checkCanReadSystemInformation(SystemSecurityContext context) {
            if (!context.getIdentity().getUser().equals(TestResourceSecurity.MANAGEMENT_USER)) {
                AccessDeniedException.denyReadSystemInformationAccess();
            }
        }
    }

    private static class OAuthBearer {
        private final String state;
        private final String tokenServer;

        public OAuthBearer(String state, String tokenServer) {
            this.state = Objects.requireNonNull(state, "state is null");
            this.tokenServer = Objects.requireNonNull(tokenServer, "tokenServer is null");
        }

        public String getState() {
            return this.state;
        }

        public String getTokenServer() {
            return this.tokenServer;
        }
    }
}

