/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.testing.Closeables;
import io.airlift.units.Duration;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.trino.server.security.jwt.JwkService;
import io.trino.server.security.jwt.JwkSigningKeyResolver;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.ScribeJavaOAuth2Client;
import io.trino.server.security.oauth2.TestingHydraIdentityProvider;
import io.trino.server.security.oauth2.TokenEndpointAuthMethod;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDynamicCallbackOAuth2Service {
    private static final String CLIENT_ID = "client";
    private static final String CLIENT_SECRET = "secret";
    private final TestingHydraIdentityProvider hydraIdP = new TestingHydraIdentityProvider();
    private final HttpClient httpClient = new JettyHttpClient(new HttpClientConfig().setTrustStorePath(Resources.getResource((String)"cert/localhost.pem").getPath()));
    private String hydraUrl;
    private SigningKeyResolver signingKeyResolver;

    @BeforeClass
    public void setUp() throws Exception {
        this.hydraIdP.start();
        this.hydraUrl = "https://localhost:" + this.hydraIdP.getAuthPort();
        this.hydraIdP.createClient(CLIENT_ID, CLIENT_SECRET, TokenEndpointAuthMethod.CLIENT_SECRET_BASIC, (List<String>)ImmutableList.of((Object)"https://localhost:8080"), "https://localhost:8080/oauth2/callback");
        this.signingKeyResolver = new JwkSigningKeyResolver(new JwkService(URI.create(this.hydraUrl + "/.well-known/jwks.json"), this.httpClient, new Duration(5.0, TimeUnit.MINUTES)));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        Closeables.closeAll((AutoCloseable[])new AutoCloseable[]{this.hydraIdP, this.httpClient});
    }

    @Test
    public void testMultipleScopes() throws Exception {
        ScribeJavaOAuth2Client.DynamicCallbackOAuth2Service service = new ScribeJavaOAuth2Client.DynamicCallbackOAuth2Service(new OAuth2Config().setAuthUrl(this.hydraUrl + "/oauth2/auth").setTokenUrl(this.hydraUrl + "/oauth2/token").setJwksUrl(this.hydraUrl + "/.well-known/jwks.json").setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setScopes("openid,offline"), this.httpClient);
        OAuth2AccessToken token = service.getAccessTokenClientCredentialsGrant();
        Claims claims = (Claims)Jwts.parser().setSigningKeyResolver(this.signingKeyResolver).parseClaimsJws(token.getAccessToken()).getBody();
        Assertions.assertThat((List)((List)claims.get("scp", List.class))).containsExactlyInAnyOrder(new Object[]{"openid", "offline"});
    }
}

