/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spiller.AesSpillCipher;
import io.trino.spiller.SpillCipher;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAesSpillCipher {
    @Test
    public void test() {
        AesSpillCipher spillCipher = new AesSpillCipher();
        for (int size = 0; size <= 257; ++size) {
            byte[] data = TestAesSpillCipher.randomBytes(size);
            byte[] encrypted = TestAesSpillCipher.encryptExact((SpillCipher)spillCipher, (byte[])data.clone());
            Assert.assertEquals((Object)data, (Object)TestAesSpillCipher.decryptExact((SpillCipher)spillCipher, encrypted));
        }
        Assert.assertNotEquals((Object)TestAesSpillCipher.encryptExact((SpillCipher)spillCipher, new byte[0]), (Object)TestAesSpillCipher.encryptExact((SpillCipher)spillCipher, new byte[0]), (String)"IV values must not be reused");
        byte[] encrypted = TestAesSpillCipher.encryptExact((SpillCipher)spillCipher, TestAesSpillCipher.randomBytes(1));
        spillCipher.close();
        spillCipher.close();
        TestAesSpillCipher.assertFailure(() -> TestAesSpillCipher.decryptExact((SpillCipher)spillCipher, encrypted), "Spill cipher already closed");
        TestAesSpillCipher.assertFailure(() -> TestAesSpillCipher.encryptExact((SpillCipher)spillCipher, TestAesSpillCipher.randomBytes(1)), "Spill cipher already closed");
    }

    private static byte[] encryptExact(SpillCipher cipher, byte[] data) {
        int outLength;
        byte[] output = new byte[cipher.encryptedMaxLength(data.length)];
        if (output.length == (outLength = cipher.encrypt(data, 0, data.length, output, 0))) {
            return output;
        }
        return Arrays.copyOfRange(output, 0, outLength);
    }

    private static byte[] decryptExact(SpillCipher cipher, byte[] encryptedData) {
        byte[] output = new byte[cipher.decryptedMaxLength(encryptedData.length)];
        int outLength = cipher.decrypt(encryptedData, 0, encryptedData.length, output, 0);
        if (outLength == output.length) {
            return output;
        }
        return Arrays.copyOfRange(output, 0, outLength);
    }

    private static void assertFailure(Assert.ThrowingRunnable runnable, String expectedErrorMessage) {
        TrinoException exception = (TrinoException)Assert.expectThrows(TrinoException.class, (Assert.ThrowingRunnable)runnable);
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        Assert.assertEquals((String)exception.getMessage(), (String)expectedErrorMessage);
    }

    private static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }
}

