/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import io.trino.execution.buffer.PageCodecMarker;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.execution.buffer.SerializedPage;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.MetadataManager;
import io.trino.operator.PageAssertions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spiller.FileSingleStreamSpiller;
import io.trino.spiller.FileSingleStreamSpillerFactory;
import io.trino.spiller.SingleStreamSpiller;
import io.trino.spiller.SpillerStats;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFileSingleStreamSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY);
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private File spillPath;

    @BeforeClass(alwaysRun=true)
    public void setUp() throws IOException {
        this.spillPath = Files.createTempDirectory("tmp", new FileAttribute[0]).toFile();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.executor.shutdown();
        MoreFiles.deleteRecursively((Path)this.spillPath.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testSpill() throws Exception {
        this.assertSpill(false, false);
    }

    @Test
    public void testSpillCompression() throws Exception {
        this.assertSpill(true, false);
    }

    @Test
    public void testSpillEncryption() throws Exception {
        this.assertSpill(false, true);
    }

    @Test
    public void testSpillEncryptionWithCompression() throws Exception {
        this.assertSpill(true, true);
    }

    private void assertSpill(boolean compression, boolean encryption) throws Exception {
        FileSingleStreamSpillerFactory spillerFactory = new FileSingleStreamSpillerFactory(this.executor, MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), new SpillerStats(), (List)ImmutableList.of((Object)this.spillPath.toPath()), 1.0, compression, encryption);
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test");
        SingleStreamSpiller singleStreamSpiller = spillerFactory.create(TYPES, bytes -> {}, memoryContext);
        Assert.assertTrue((boolean)(singleStreamSpiller instanceof FileSingleStreamSpiller));
        FileSingleStreamSpiller spiller = (FileSingleStreamSpiller)singleStreamSpiller;
        Page page = this.buildPage();
        Assert.assertEquals((long)memoryContext.getBytes(), (long)4096L);
        spiller.spill(page).get();
        spiller.spill((Iterator)Iterators.forArray((Object[])new Page[]{page, page, page})).get();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath.toPath()).size(), (int)1);
        try (InputStream is = Files.newInputStream((Path)MoreFiles.listFiles((Path)this.spillPath.toPath()).get(0), new OpenOption[0]);){
            Iterator serializedPages = PagesSerdeUtil.readSerializedPages((SliceInput)new InputStreamSliceInput(is));
            Assert.assertTrue((boolean)serializedPages.hasNext(), (String)"at least one page should be successfully read back");
            byte markers = ((SerializedPage)serializedPages.next()).getPageCodecMarkers();
            Assert.assertEquals((boolean)PageCodecMarker.COMPRESSED.isSet(markers), (boolean)compression);
            Assert.assertEquals((boolean)PageCodecMarker.ENCRYPTED.isSet(markers), (boolean)encryption);
        }
        Iterator spilledPagesIterator = spiller.getSpilledPages();
        Assert.assertEquals((long)memoryContext.getBytes(), (long)4096L);
        ImmutableList spilledPages = ImmutableList.copyOf((Iterator)spilledPagesIterator);
        Assert.assertEquals((int)4, (int)spilledPages.size());
        for (int i = 0; i < 4; ++i) {
            PageAssertions.assertPageEquals(TYPES, page, (Page)spilledPages.get(i));
        }
        spiller.close();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath.toPath()).size(), (int)0);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
    }

    private Page buildPage() {
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        BlockBuilder col2 = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        BlockBuilder col3 = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        col1.writeLong(42L).closeEntry();
        col2.writeLong(Double.doubleToLongBits(43.0)).closeEntry();
        col3.writeLong(Double.doubleToLongBits(43.0)).writeLong(1L).closeEntry();
        return new Page(new Block[]{col1.build(), col2.build(), col3.build()});
    }
}

