/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.parser.ParserAssert;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Identifier;
import java.util.Comparator;
import java.util.Locale;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTypeSignatureTranslator {
    private static final SqlParser SQL_PARSER = new SqlParser();

    private void assertRoundTrip(String expression) {
        ((ParserAssert)((ParserAssert)Assertions.assertThat((AssertProvider)ParserAssert.type((String)expression))).ignoringLocation().withComparatorForType(Comparator.comparing(identifier -> identifier.getValue().toLowerCase(Locale.ENGLISH)), Identifier.class)).isEqualTo((Object)TypeSignatureTranslator.toDataType((TypeSignature)TypeSignatureTranslator.toTypeSignature((DataType)SQL_PARSER.createType(expression))));
    }

    @Test
    public void testSimpleTypes() {
        this.assertRoundTrip("varchar");
        this.assertRoundTrip("BIGINT");
        this.assertRoundTrip("DOUBLE");
        this.assertRoundTrip("BOOLEAN");
    }

    @Test
    public void testDayTimeTypes() {
        this.assertRoundTrip("TIMESTAMP");
        this.assertRoundTrip("TIMESTAMP(1)");
        this.assertRoundTrip("TIMESTAMP WITHOUT TIME ZONE");
        this.assertRoundTrip("TIMESTAMP(1) WITHOUT TIME ZONE");
        this.assertRoundTrip("TIMESTAMP WITH TIME ZONE");
        this.assertRoundTrip("TIME");
        this.assertRoundTrip("TIME WITHOUT TIME ZONE");
        this.assertRoundTrip("TIME WITH TIME ZONE");
    }

    @Test
    public void testIntervalTypes() {
        this.assertRoundTrip("INTERVAL DAY TO SECOND");
        this.assertRoundTrip("INTERVAL YEAR TO MONTH");
    }

    @Test
    public void testParametricTypes() {
        this.assertRoundTrip("ARRAY(TINYINT)");
        this.assertRoundTrip("MAP(BIGINT, SMALLINT)");
        this.assertRoundTrip("VARCHAR(123)");
        this.assertRoundTrip("DECIMAL(1)");
        this.assertRoundTrip("DECIMAL(1, 38)");
    }

    @Test
    public void testArray() {
        this.assertRoundTrip("foo(42, 55) ARRAY");
        this.assertRoundTrip("VARCHAR(7) ARRAY");
        this.assertRoundTrip("VARCHAR(7) ARRAY array");
    }

    @Test
    public void testRowType() {
        this.assertRoundTrip("ROW(a BIGINT, b VARCHAR)");
        this.assertRoundTrip("ROW(a BIGINT,b VARCHAR)");
        this.assertRoundTrip("ROW(\"a\" BIGINT, \"from\" VARCHAR)");
        this.assertRoundTrip("ROW(\"$x\" BIGINT, \"$y\" VARCHAR)");
    }

    @Test
    public void testComplexTypes() {
        this.assertRoundTrip("ROW(x BIGINT, y DOUBLE PRECISION, z ROW(m array<bigint>,n map<double,varchar>))");
    }
}

