/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=5)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkPageProcessor {
    private static final int EXTENDED_PRICE = 0;
    private static final int DISCOUNT = 1;
    private static final int SHIP_DATE = 2;
    private static final int QUANTITY = 3;
    private static final Slice MIN_SHIP_DATE = Slices.utf8Slice((String)"1994-01-01");
    private static final Slice MAX_SHIP_DATE = Slices.utf8Slice((String)"1995-01-01");
    private Page inputPage;
    private PageProcessor compiledProcessor;

    @Setup
    public void setup() {
        this.inputPage = BenchmarkPageProcessor.createInputPage();
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        RowExpression filterExpression = BenchmarkPageProcessor.createFilterExpression((Metadata)metadata);
        RowExpression projectExpression = BenchmarkPageProcessor.createProjectExpression((Metadata)metadata);
        ExpressionCompiler expressionCompiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
        this.compiledProcessor = (PageProcessor)expressionCompiler.compilePageProcessor(Optional.of(filterExpression), (List)ImmutableList.of((Object)projectExpression)).get();
    }

    @Benchmark
    public Page handCoded() {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE));
        int count = Tpch1FilterAndProject.process(this.inputPage, 0, this.inputPage.getPositionCount(), pageBuilder);
        Preconditions.checkState((count == this.inputPage.getPositionCount() ? 1 : 0) != 0);
        return pageBuilder.build();
    }

    @Benchmark
    public List<Optional<Page>> compiled() {
        return ImmutableList.copyOf((Iterator)this.compiledProcessor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), this.inputPage));
    }

    public static void main(String[] args) throws RunnerException {
        new BenchmarkPageProcessor().setup();
        Benchmarks.benchmark(BenchmarkPageProcessor.class).run();
    }

    private static Page createInputPage() {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE));
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < 10000; ++i) {
            pageBuilder.declarePosition();
            LineItem lineItem = (LineItem)iterator.next();
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.getExtendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.getDiscount());
            DateType.DATE.writeLong(pageBuilder.getBlockBuilder(2), (long)lineItem.getShipDate());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), (double)lineItem.getQuantity());
        }
        return pageBuilder.build();
    }

    private static RowExpression createFilterExpression(Metadata metadata) {
        return new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, new RowExpression[]{new CallExpression(metadata.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)), (List)ImmutableList.of((Object)Expressions.constant((Object)MIN_SHIP_DATE, (Type)VarcharType.VARCHAR), (Object)Expressions.field((int)2, (Type)VarcharType.VARCHAR))), new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, new RowExpression[]{new CallExpression(metadata.resolveOperator(OperatorType.LESS_THAN, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)), (List)ImmutableList.of((Object)Expressions.field((int)2, (Type)VarcharType.VARCHAR), (Object)Expressions.constant((Object)MAX_SHIP_DATE, (Type)VarcharType.VARCHAR))), new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, new RowExpression[]{new CallExpression(metadata.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (List)ImmutableList.of((Object)Expressions.constant((Object)0.05, (Type)DoubleType.DOUBLE), (Object)Expressions.field((int)1, (Type)DoubleType.DOUBLE))), new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, new RowExpression[]{new CallExpression(metadata.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (List)ImmutableList.of((Object)Expressions.field((int)1, (Type)DoubleType.DOUBLE), (Object)Expressions.constant((Object)0.07, (Type)DoubleType.DOUBLE))), new CallExpression(metadata.resolveOperator(OperatorType.LESS_THAN, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (List)ImmutableList.of((Object)Expressions.field((int)3, (Type)DoubleType.DOUBLE), (Object)Expressions.constant((Object)24.0, (Type)DoubleType.DOUBLE)))})})})});
    }

    private static RowExpression createProjectExpression(Metadata metadata) {
        return new CallExpression(metadata.resolveOperator(OperatorType.MULTIPLY, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)DoubleType.DOUBLE), (Object)Expressions.field((int)1, (Type)DoubleType.DOUBLE)));
    }

    private static final class Tpch1FilterAndProject {
        private Tpch1FilterAndProject() {
        }

        public static int process(Page page, int start, int end, PageBuilder pageBuilder) {
            int position;
            Block discountBlock = page.getBlock(1);
            for (position = start; position < end; ++position) {
                if (!Tpch1FilterAndProject.filter(position, discountBlock, page.getBlock(2), page.getBlock(3))) continue;
                Tpch1FilterAndProject.project(position, pageBuilder, page.getBlock(0), discountBlock);
            }
            return position;
        }

        private static void project(int position, PageBuilder pageBuilder, Block extendedPriceBlock, Block discountBlock) {
            pageBuilder.declarePosition();
            if (discountBlock.isNull(position) || extendedPriceBlock.isNull(position)) {
                pageBuilder.getBlockBuilder(0).appendNull();
            } else {
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), DoubleType.DOUBLE.getDouble(extendedPriceBlock, position) * DoubleType.DOUBLE.getDouble(discountBlock, position));
            }
        }

        private static boolean filter(int position, Block discountBlock, Block shipDateBlock, Block quantityBlock) {
            return !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MIN_SHIP_DATE) >= 0 && !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MAX_SHIP_DATE) < 0 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && DoubleType.DOUBLE.getDouble(quantityBlock, position) < 24.0;
        }
    }
}

