/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.DynamicFilters;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestDynamicFilter
extends BasePlanTest {
    public TestDynamicFilter() {
        super((Map<String, String>)ImmutableMap.of((Object)"enable_dynamic_filtering", (Object)"true", (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.NONE.name(), (Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.BROADCAST.name()));
    }

    @Test
    public void testLeftEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o LEFT JOIN lineitem l ON l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of(), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testFullEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o FULL JOIN lineitem l ON l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of(), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRightEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"LINEITEM_OK"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testRightNonEquiJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o RIGHT JOIN lineitem l ON l.orderkey < o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("LINEITEM_OK < ORDERS_OK"), Optional.of(ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("ORDERS_OK", ComparisonExpression.Operator.GREATER_THAN, "LINEITEM_OK"))), Optional.empty(), Optional.empty(), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testEmptyJoinCriteria() {
        this.assertPlan("SELECT o.orderkey FROM orders o CROSS JOIN lineitem l", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of(), PlanMatchPattern.tableScan("orders"), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem")))));
    }

    @Test
    public void testCrossJoinInequalityDF() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey > l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY > L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.GREATER_THAN, "L_ORDERKEY")), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testCrossJoinBetweenDF() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey BETWEEN l.orderkey AND l.partkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY BETWEEN L_ORDERKEY AND L_PARTKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, "L_ORDERKEY"), (Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, "L_PARTKEY")), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey")))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey BETWEEN l.orderkey AND l.partkey - 1", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY BETWEEN L_ORDERKEY AND L_PARTKEY - BIGINT '1'", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, "L_ORDERKEY")), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey")))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey BETWEEN l.orderkey + 1 AND l.partkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY BETWEEN L_ORDERKEY + BIGINT '1' AND L_PARTKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, "L_PARTKEY")), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey")))))));
    }

    @Test
    public void testCrossJoinInequalityNoDFWithCast() {
        this.assertPlan("SELECT o.comment, l.comment FROM lineitem l, orders o WHERE o.comment < l.comment", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(L_COMMENT AS varchar(79)) > O_COMMENT", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_COMMENT", (Object)"comment")), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_COMMENT", (Object)"comment")))))));
        this.assertPlan("SELECT o.comment, l.comment FROM orders o, lineitem l WHERE o.comment < l.comment", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_COMMENT < CAST(L_COMMENT AS varchar(79))", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_COMMENT", (Object)"comment")), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_COMMENT", (Object)"comment")))))));
    }

    @Test
    public void testJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"LINEITEM_OK"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testIsNotDistinctFromJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey IS NOT DISTINCT FROM o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY IS NOT DISTINCT FROM L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.EQUAL, "L_ORDERKEY", true)), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey IS DISTINCT FROM o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY IS DISTINCT FROM L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.extendedprice IS NOT DISTINCT FROM o.totalprice", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_TOTALPRICE IS NOT DISTINCT FROM L_EXTENDEDPRICE", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_TOTALPRICE", (Object)"totalprice")), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_EXTENDEDPRICE", (Object)"extendedprice")))))));
    }

    @Test
    public void testJoinOnCast() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE cast(l.orderkey as int) = cast(o.orderkey as int)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr_orders", "expr_lineitem")), (Map<String, String>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_orders", (Object)PlanMatchPattern.expression("CAST(ORDERS_OK AS int)")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_lineitem", (Object)PlanMatchPattern.expression("CAST(LINEITEM_OK AS int)")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = cast(o.orderkey as int)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr_orders", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_orders", (Object)PlanMatchPattern.expression("CAST(CAST(ORDERS_OK AS int) AS bigint)")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testJoinImplicitCoercions() {
        this.assertPlan("SELECT o.orderkey FROM lineitem l, orders o WHERE l.linenumber = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr_linenumber", "ORDERS_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_linenumber", (Object)PlanMatchPattern.expression("CAST(LINEITEM_LN AS bigint)")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_LN", (Object)"linenumber"))).with(this.numberOfDynamicFilters(1)))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testJoinMultipleEquiJoinClauses() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey AND l.partkey = o.custkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK"), PlanMatchPattern.equiJoinClause("ORDERS_CK", "LINEITEM_PK")), (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"LINEITEM_OK", (Object)"ORDERS_CK", (Object)"LINEITEM_PK"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey", (Object)"ORDERS_CK", (Object)"custkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey", (Object)"LINEITEM_PK", (Object)"partkey")))))));
    }

    @Test
    public void testJoinWithOrderBySameKey() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey ORDER BY l.orderkey ASC, o.orderkey ASC", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"LINEITEM_OK"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testUncorrelatedSubqueries() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey = (SELECT orderkey FROM lineitem ORDER BY orderkey LIMIT 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("X", "Y")), (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"Y"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.project(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testInnerInequalityJoinWithEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_SHIPPRIORITY", "L_LINENUMBER")), Optional.of("O_ORDERKEY < L_ORDERKEY"), Optional.of(ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_SHIPPRIORITY", ComparisonExpression.Operator.EQUAL, "L_LINENUMBER"), (Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.LESS_THAN, "L_ORDERKEY"))), Optional.empty(), Optional.empty(), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testSubTreeJoinDFOnProbeSide() {
        this.assertPlan("SELECT part.partkey from part JOIN (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) ON part.partkey = lineitem.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("PART_PK", "LINEITEM_OK")), (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"LINEITEM_OK"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_OK", "ORDERS_OK")), (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"ORDERS_OK"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))))));
    }

    @Test
    public void testSubTreeJoinDFOnBuildSide() {
        this.assertPlan("SELECT part.partkey from (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) JOIN part ON lineitem.orderkey = part.partkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_OK", "PART_PK")), (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"PART_PK", (Object)"ORDERS_OK", (Object)"PART_PK"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_OK", "ORDERS_OK")), (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"ORDERS_OK"), PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))).with(this.numberOfDynamicFilters(2))), PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))).with(this.numberOfDynamicFilters(1)))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey")))))));
    }

    @Test
    public void testNestedDynamicFiltersRemoval() {
        this.assertPlan("WITH t AS (  SELECT o.clerk FROM (    (orders o LEFT JOIN orders o1 ON o1.clerk = o.clerk)       LEFT JOIN orders o2 ON o2.clerk = o1.clerk)) SELECT t.clerk FROM orders o3 JOIN t ON t.clerk = o3.clerk", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_CK", "ORDERS_CK6")), (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK", (Object)"ORDERS_CK6"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK", (Object)"clerk"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_CK16", "ORDERS_CK27")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_CK6", "ORDERS_CK16")), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK6", (Object)"clerk"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK16", (Object)"clerk")))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CK27", (Object)"clerk"))))))));
    }

    @Test
    public void testNonPushedDownJoinFilterRemoval() {
        this.assertPlan("SELECT 1 FROM part t0, part t1, part t2 WHERE t0.partkey = t1.partkey AND t0.partkey = t2.partkey AND t0.size + t1.size = t2.size", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("K0", "K2"), PlanMatchPattern.equiJoinClause("S", "V2")), Optional.empty(), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"S", (Object)PlanMatchPattern.expression("V0 + V1")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("K0", "K1")), (Map<String, String>)ImmutableMap.of((Object)"K0", (Object)"K1"), PlanMatchPattern.project(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K0", (Object)"partkey", (Object)"V0", (Object)"size"))).with(this.numberOfDynamicFilters(2))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K1", (Object)"partkey", (Object)"V1", (Object)"size"))).with(this.numberOfDynamicFilters(1))))))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"K2", (Object)"partkey", (Object)"V2", (Object)"size")))))));
    }

    @Test
    public void testSemiJoin() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", true, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testNonFilteringSemiJoin() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey NOT IN (SELECT orderkey FROM lineitem WHERE linenumber < 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", false, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber < 0) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("X", "Y", "S", false, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))));
    }

    @Test
    public void testSemiJoinWithStaticFiltering() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0) AND orderkey > 0", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", true, PlanMatchPattern.anyTree(PlanMatchPattern.filter("X > BIGINT '0'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testMultiSemiJoin() {
        this.assertPlan("SELECT part.partkey FROM part WHERE part.partkey IN (SELECT lineitem.partkey FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders))", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter("S0", PlanMatchPattern.project(PlanMatchPattern.semiJoin("PART_PK", "LINEITEM_PK", "S0", true, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("S1", PlanMatchPattern.project(PlanMatchPattern.semiJoin("LINEITEM_OK", "ORDERS_OK", "S1", true, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_PK", (Object)"partkey", (Object)"LINEITEM_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))))))))))));
    }

    @Test
    public void testSemiJoinUnsupportedDynamicFilterRemoval() {
        this.assertPlan("WITH t AS (SELECT lineitem.partkey + 1000 partkey FROM lineitem) SELECT t.partkey FROM t WHERE t.partkey IN (SELECT part.partkey FROM part)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter("S0", PlanMatchPattern.project(PlanMatchPattern.semiJoin("LINEITEM_PK_PLUS_1000", "PART_PK", "S0", false, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"LINEITEM_PK_PLUS_1000", (Object)PlanMatchPattern.expression("(LINEITEM_PK + BIGINT '1000')")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_PK", (Object)"partkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"PART_PK", (Object)"partkey"))))))));
    }

    private Matcher numberOfDynamicFilters(final int numberOfDynamicFilters) {
        return new Matcher(){

            @Override
            public boolean shapeMatches(PlanNode node) {
                return node instanceof FilterNode;
            }

            @Override
            public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
                FilterNode filterNode = (FilterNode)node;
                return new MatchResult(DynamicFilters.extractDynamicFilters((Expression)filterNode.getPredicate()).getDynamicConjuncts().size() == numberOfDynamicFilters);
            }
        };
    }

    private Session noSemiJoinRewrite() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").build();
    }
}

