/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.planner.LocalDynamicFilterConsumer;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.assertions.Assert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.testng.annotations.Test;

public class TestLocalDynamicFilterConsumer
extends BasePlanTest {
    public TestLocalDynamicFilterConsumer() {
        super((Map<String, String>)ImmutableMap.of((Object)"force_single_node_output", (Object)"false", (Object)"enable_dynamic_filtering", (Object)"true", (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.NONE.name(), (Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.BROADCAST.name()));
    }

    @Test
    public void testSimple() throws Exception {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getDynamicFilterDomains();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L)));
    }

    @Test
    public void testShortCircuitOnAllTupleDomain() throws Exception {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), 2);
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getDynamicFilterDomains();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.all((Type)IntegerType.INTEGER))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.all((Type)IntegerType.INTEGER)));
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.all((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMultiplePartitions() throws Exception {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), 2);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getDynamicFilterDomains();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L))));
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)10L, (Object)20L))));
    }

    @Test
    public void testAllDomain() throws Exception {
        DynamicFilterId filter1 = new DynamicFilterId("123");
        DynamicFilterId filter2 = new DynamicFilterId("124");
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)filter1, (Object)0, (Object)filter2, (Object)1), (Map)ImmutableMap.of((Object)filter1, (Object)IntegerType.INTEGER, (Object)filter2, (Object)IntegerType.INTEGER), 1);
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getDynamicFilterDomains();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filter1, (Object)Domain.all((Type)IntegerType.INTEGER), (Object)filter2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)filter1, (Object)Domain.all((Type)IntegerType.INTEGER), (Object)filter2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
    }

    @Test
    public void testNone() throws Exception {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getDynamicFilterDomains();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.none());
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.none((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMultipleColumns() throws Exception {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER, (Object)new DynamicFilterId("456"), (Object)IntegerType.INTEGER), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getDynamicFilterDomains();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L)));
    }

    @Test
    public void testMultiplePartitionsAndColumns() throws Exception {
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER, (Object)new DynamicFilterId("456"), (Object)BigintType.BIGINT), 2);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getDynamicFilterDomains();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)100L))));
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)200L))));
        Assert.assertEquals((Map)((Map)result.get()), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)10L, (Object)20L)), (Object)new DynamicFilterId("456"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)100L, (Object)200L))));
    }

    @Test
    public void testDynamicFilterPruning() throws Exception {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
        Symbol left1 = planBuilder.symbol("left1", (Type)BigintType.BIGINT);
        Symbol left2 = planBuilder.symbol("left2", (Type)IntegerType.INTEGER);
        Symbol left3 = planBuilder.symbol("left3", (Type)SmallintType.SMALLINT);
        Symbol right1 = planBuilder.symbol("right1", (Type)BigintType.BIGINT);
        Symbol right2 = planBuilder.symbol("right2", (Type)IntegerType.INTEGER);
        Symbol right3 = planBuilder.symbol("right3", (Type)SmallintType.SMALLINT);
        DynamicFilterId filter1 = new DynamicFilterId("filter1");
        DynamicFilterId filter2 = new DynamicFilterId("filter2");
        DynamicFilterId filter3 = new DynamicFilterId("filter3");
        JoinNode joinNode = planBuilder.join(JoinNode.Type.INNER, (PlanNode)planBuilder.values(left1, left2, left3), (PlanNode)planBuilder.values(right1, right2, right3), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(left1, right1), (Object)new JoinNode.EquiJoinClause(left2, right2), (Object)new JoinNode.EquiJoinClause(left3, right3)), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)filter1, (Object)right1, (Object)filter2, (Object)right2, (Object)filter3, (Object)right3));
        LocalDynamicFilterConsumer consumer = LocalDynamicFilterConsumer.create((JoinNode)joinNode, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT), (int)1, (Set)ImmutableSet.of((Object)filter1, (Object)filter3));
        Assert.assertEquals((Map)consumer.getBuildChannels(), (Map)ImmutableMap.of((Object)filter1, (Object)0, (Object)filter3, (Object)2));
        consumer.getTupleDomainConsumer().accept(TupleDomain.none());
        Assert.assertEquals((Map)((Map)consumer.getDynamicFilterDomains().get()), (Map)ImmutableMap.of((Object)filter1, (Object)Domain.none((Type)BigintType.BIGINT), (Object)filter3, (Object)Domain.none((Type)SmallintType.SMALLINT)));
    }
}

