/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.connector.informationschema.InformationSchemaConnector;
import io.trino.connector.system.SystemConnector;
import io.trino.metadata.Catalog;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestMaterializedViews
extends BasePlanTest {
    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        String catalog = "local";
        String schema = "tiny";
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(catalog).setSchema(schema).setSystemProperty("task_concurrency", "1");
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
        Catalog testCatalog = this.createTestingCatalog(catalog, new CatalogName(catalog), queryRunner);
        queryRunner.getCatalogManager().registerCatalog(testCatalog);
        TestingMetadata testingConnectorMetadata = (TestingMetadata)testCatalog.getConnector(new CatalogName(catalog)).getMetadata(null);
        Metadata metadata = queryRunner.getMetadata();
        SchemaTableName testTable = new SchemaTableName(schema, "test_table");
        queryRunner.inTransaction(session -> {
            metadata.createTable(session, catalog, new ConnectorTableMetadata(testTable, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT))), false);
            return null;
        });
        SchemaTableName storageTable = new SchemaTableName(schema, "storage_table");
        queryRunner.inTransaction(session -> {
            metadata.createTable(session, catalog, new ConnectorTableMetadata(storageTable, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT))), false);
            return null;
        });
        QualifiedObjectName freshMaterializedView = new QualifiedObjectName(catalog, schema, "fresh_materialized_view");
        ConnectorMaterializedViewDefinition materializedViewDefinition = new ConnectorMaterializedViewDefinition("SELECT a FROM test_table", Optional.of(new CatalogSchemaTableName(catalog, schema, "storage_table")), Optional.of(catalog), Optional.of(schema), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("a", BigintType.BIGINT.getTypeId())), Optional.empty(), "some user", (Map)ImmutableMap.of());
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, freshMaterializedView, materializedViewDefinition, false, false);
            return null;
        });
        testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedView.asSchemaTableName());
        QualifiedObjectName notFreshMaterializedView = new QualifiedObjectName(catalog, schema, "not_fresh_materialized_view");
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, notFreshMaterializedView, materializedViewDefinition, false, false);
            return null;
        });
        testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedView.asSchemaTableName());
        return queryRunner;
    }

    @Test
    public void testFreshMaterializedView() {
        this.assertPlan("SELECT * FROM fresh_materialized_view", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("storage_table")));
    }

    @Test
    public void testNotFreshMaterializedView() {
        this.assertPlan("SELECT * FROM not_fresh_materialized_view", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("test_table")));
    }

    private Catalog createTestingCatalog(String catalogName, CatalogName catalog, LocalQueryRunner queryRunner) {
        CatalogName systemId = CatalogName.createSystemTablesCatalogName((CatalogName)catalog);
        Connector connector = TestMaterializedViews.createTestingConnector();
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        return new Catalog(catalogName, catalog, connector, CatalogName.createInformationSchemaCatalogName((CatalogName)catalog), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, queryRunner.getMetadata(), (AccessControl)queryRunner.getAccessControl()), systemId, (Connector)new SystemConnector((InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> queryRunner.getTransactionManager().getConnectorTransaction(transactionId, catalog)));
    }

    private static Connector createTestingConnector() {
        return new Connector(){
            private final ConnectorMetadata metadata = new TestingMetadata();

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return new ConnectorTransactionHandle(){};
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return this.metadata;
            }
        };
    }
}

