/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.SortExpressionContext;
import io.trino.sql.planner.SortExpressionExtractor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSortExpressionExtractor {
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("b1"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("b2"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("p1"), (Object)BigintType.BIGINT).put((Object)new Symbol("p2"), (Object)DoubleType.DOUBLE).build());
    private static final Set<Symbol> BUILD_SYMBOLS = ImmutableSet.of((Object)new Symbol("b1"), (Object)new Symbol("b2"));
    private final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testGetSortExpression() {
        this.assertGetSortExpression("p1 > b1", "b1");
        this.assertGetSortExpression("b2 <= p1", "b2");
        this.assertGetSortExpression("b2 > p1", "b2");
        this.assertGetSortExpression("b2 > sin(p1)", "b2");
        this.assertNoSortExpression("b2 > random(p1)");
        this.assertGetSortExpression("b2 > random(p1) AND b2 > p1", "b2", "b2 > p1");
        this.assertGetSortExpression("b2 > random(p1) AND b1 > p1", "b1", "b1 > p1");
        this.assertNoSortExpression("b1 > p1 + b2");
        this.assertNoSortExpression("sin(b1) > p1");
        this.assertNoSortExpression("b1 <= p1 OR b2 <= p1");
        this.assertNoSortExpression("sin(b2) > p1 AND (b2 <= p1 OR b2 <= p1 + 10)");
        this.assertGetSortExpression("sin(b2) > p1 AND (b2 <= p1 AND b2 <= p1 + 10)", "b2", "b2 <= p1", "b2 <= p1 + 10");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1", "b1");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1 AND b2 > p1", "b1", "b1 > p1", "b1 <= p1");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1 AND b2 > p1 AND b2 < p1 + 10 AND b2 > p2", "b2", "b2 > p1", "b2 < p1 + 10", "b2 > p2");
        this.assertGetSortExpression("p1 BETWEEN b1 AND b2", "b1", "p1 >= b1");
        this.assertGetSortExpression("p1 BETWEEN p2 AND b1", "b1", "p1 <= b1");
        this.assertGetSortExpression("b1 BETWEEN p1 AND p2", "b1", "b1 >= p1");
        this.assertGetSortExpression("b1 > p1 AND p1 BETWEEN b1 AND b2", "b1", "b1 > p1", "p1 >= b1");
    }

    private Expression expression(String sql) {
        return ExpressionTestUtils.planExpression(this.metadata, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql, new ParsingOptions())));
    }

    private void assertNoSortExpression(String expression) {
        this.assertNoSortExpression(this.expression(expression));
    }

    private void assertNoSortExpression(Expression expression) {
        Optional actual = SortExpressionExtractor.extractSortExpression((Metadata)this.metadata, BUILD_SYMBOLS, (Expression)expression);
        Assert.assertEquals((Object)actual, Optional.empty());
    }

    private void assertGetSortExpression(String expression, String expectedSymbol) {
        this.assertGetSortExpression(this.expression(expression), expectedSymbol);
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol) {
        this.assertGetSortExpression(expression, expectedSymbol, ExpressionUtils.extractConjuncts((Expression)expression));
    }

    private void assertGetSortExpression(String expression, String expectedSymbol, String ... searchExpressions) {
        this.assertGetSortExpression(this.expression(expression), expectedSymbol, searchExpressions);
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol, String ... searchExpressions) {
        List searchExpressionList = (List)Arrays.stream(searchExpressions).map(this::expression).collect(ImmutableList.toImmutableList());
        this.assertGetSortExpression(expression, expectedSymbol, searchExpressionList);
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol, List<Expression> searchExpressions) {
        Optional<SortExpressionContext> expected = Optional.of(new SortExpressionContext((Expression)new SymbolReference(expectedSymbol), searchExpressions));
        Optional actual = SortExpressionExtractor.extractSortExpression((Metadata)this.metadata, BUILD_SYMBOLS, (Expression)expression);
        Assert.assertEquals((Object)actual, expected);
    }
}

