/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushLimitThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestPushLimitThroughOuterJoin
extends BaseRuleTest {
    public TestPushLimitThroughOuterJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushLimitThroughLeftJoin() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.limit(1L, PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.values("leftKey")), PlanMatchPattern.values("rightKey"))));
    }

    @Test
    public void testPushLimitThroughRightJoin() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.limit(1L, PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.values("leftKey"), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.values("rightKey")))));
    }

    @Test
    public void testPushLimitThroughFullOuterJoin() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushWhenAlreadyLimited() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.limit(1L, (PlanNode)p.values(5, leftKey)), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushLimitWithTies() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testLimitWithPreSortedInputsLeftJoin() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)rightKey), (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)leftKey), (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, (List<String>)ImmutableList.of((Object)"leftKey"), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, (List<String>)ImmutableList.of((Object)"leftKey"), PlanMatchPattern.values("leftKey")), PlanMatchPattern.values("rightKey"))));
    }

    @Test
    public void testLimitWithPreSortedInputsRightJoin() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)leftKey), (PlanNode)p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)rightKey), (PlanNode)p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, (List<String>)ImmutableList.of((Object)"rightKey"), PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.values("leftKey"), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, (List<String>)ImmutableList.of((Object)"rightKey"), PlanMatchPattern.values("rightKey")))));
    }
}

