/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushdownLimitIntoRowNumber;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushdownLimitIntoRowNumber
extends BaseRuleTest {
    public TestPushdownLimitIntoRowNumber() {
        super(new Plugin[0]);
    }

    @Test
    public void testLimitAboveRowNumber() {
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoRowNumber()).on(p -> p.limit(3L, (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(5), p.symbol("row_number"), (PlanNode)p.values(p.symbol("a"))))).matches(PlanMatchPattern.rowNumber(rowNumber -> rowNumber.partitionBy((List<String>)ImmutableList.of()).maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoRowNumber()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(3L, (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(5), p.symbol("row_number"), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.limit(3L, PlanMatchPattern.rowNumber(rowNumber -> rowNumber.partitionBy((List<String>)ImmutableList.of((Object)"a")).maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values("a"))));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoRowNumber()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(3L, (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.empty(), p.symbol("row_number"), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.limit(3L, PlanMatchPattern.rowNumber(rowNumber -> rowNumber.partitionBy((List<String>)ImmutableList.of((Object)"a")).maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values("a"))));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoRowNumber()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(5L, (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), p.symbol("row_number"), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.rowNumber(rowNumber -> rowNumber.partitionBy((List<String>)ImmutableList.of()).maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values("a")));
    }

    @Test
    public void testZeroLimit() {
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoRowNumber()).on(p -> p.limit(0L, (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(5), p.symbol("row_number"), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testTiesLimit() {
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoRowNumber()).on(p -> p.limit(0L, (List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(5), p.symbol("row_number"), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testIdenticalLimit() {
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoRowNumber()).on(p -> p.limit(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(5), p.symbol("row_number"), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testLimitWithPreSortedInputs() {
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoRowNumber()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(5L, false, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), p.symbol("row_number"), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.rowNumber(rowNumber -> rowNumber.partitionBy((List<String>)ImmutableList.of()).maxRowCountPerPartition(Optional.of(3)).orderSensitive(true), PlanMatchPattern.values("a")));
    }
}

