/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformExistsApplyToCorrelatedJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestTransformExistsApplyToCorrelatedJoin
extends BaseRuleTest {
    public TestTransformExistsApplyToCorrelatedJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new TransformExistsApplyToCorrelatedJoin(this.tester().getMetadata())).on(p -> p.values(p.symbol("a"))).doesNotFire();
        this.tester().assertThat((Rule<?>)new TransformExistsApplyToCorrelatedJoin(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule<?>)new TransformExistsApplyToCorrelatedJoin(this.tester().getMetadata())).on(p -> p.apply(Assignments.of((Symbol)p.symbol("b", (Type)BooleanType.BOOLEAN), (Expression)PlanBuilder.expression("EXISTS(SELECT TRUE)")), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of(), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("(\"count_expr\" > CAST(0 AS bigint))")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_expr", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values(new String[0])))));
    }

    @Test
    public void testRewritesToLimit() {
        this.tester().assertThat((Rule<?>)new TransformExistsApplyToCorrelatedJoin(this.tester().getMetadata())).on(p -> p.apply(Assignments.of((Symbol)p.symbol("b", (Type)BooleanType.BOOLEAN), (Expression)PlanBuilder.expression("EXISTS(SELECT TRUE)")), (List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of(), (PlanNode)p.filter(PlanBuilder.expression("corr = column"), (PlanNode)p.values(p.symbol("column")))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("COALESCE(subquerytrue, false)")), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.values("corr"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquerytrue", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.limit(1L, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("column"))))))));
    }
}

