/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.security.AccessControl;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.test.RuleAssert;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RuleTester
implements Closeable {
    public static final String CATALOG_ID = "local";
    public static final CatalogName CONNECTOR_ID = new CatalogName("local");
    private final Metadata metadata;
    private final Session session;
    private final LocalQueryRunner queryRunner;
    private final TransactionManager transactionManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final AccessControl accessControl;
    private final TypeAnalyzer typeAnalyzer;

    public static RuleTester defaultRuleTester() {
        return RuleTester.defaultRuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of(), Optional.empty());
    }

    public static RuleTester defaultRuleTester(List<Plugin> plugins, Map<String, String> sessionProperties, Optional<Integer> nodeCountForStats) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(CATALOG_ID).setSchema("tiny").setSystemProperty("task_concurrency", "1");
        for (Map.Entry<String, String> entry : sessionProperties.entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        Session session = sessionBuilder.build();
        LocalQueryRunner queryRunner = nodeCountForStats.map(nodeCount -> LocalQueryRunner.builder((Session)session).withNodeCountForStats(nodeCount.intValue()).build()).orElseGet(() -> LocalQueryRunner.create((Session)session));
        queryRunner.createCatalog((String)session.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        plugins.forEach(arg_0 -> ((LocalQueryRunner)queryRunner).installPlugin(arg_0));
        return new RuleTester(queryRunner);
    }

    public RuleTester(LocalQueryRunner queryRunner) {
        this.queryRunner = Objects.requireNonNull(queryRunner, "queryRunner is null");
        this.session = queryRunner.getDefaultSession();
        this.metadata = queryRunner.getMetadata();
        this.transactionManager = queryRunner.getTransactionManager();
        this.splitManager = queryRunner.getSplitManager();
        this.pageSourceManager = queryRunner.getPageSourceManager();
        this.accessControl = queryRunner.getAccessControl();
        this.typeAnalyzer = new TypeAnalyzer(queryRunner.getSqlParser(), this.metadata);
    }

    public RuleAssert assertThat(Rule<?> rule) {
        return new RuleAssert(this.metadata, this.queryRunner.getStatsCalculator(), this.queryRunner.getEstimatedExchangesCostCalculator(), this.session, rule, this.transactionManager, this.accessControl);
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Session getSession() {
        return this.session;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public TypeAnalyzer getTypeAnalyzer() {
        return this.typeAnalyzer;
    }

    public CatalogName getCurrentConnectorId() {
        return (CatalogName)((Optional)this.queryRunner.inTransaction(transactionSession -> this.metadata.getCatalogHandle(transactionSession, (String)this.session.getCatalog().get()))).get();
    }

    public LocalQueryRunner getQueryRunner() {
        return this.queryRunner;
    }
}

