/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.cost.TaskCountEstimator;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.DetermineTableScanNodePartitioning;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.AddExchanges;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestEliminateSorts
extends BasePlanTest {
    private static final String QUANTITY_ALIAS = "QUANTITY";
    private static final ExpectedValueProvider<WindowNode.Specification> windowSpec = PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"QUANTITY"), (Map<String, SortOrder>)ImmutableMap.of((Object)"QUANTITY", (Object)SortOrder.ASC_NULLS_LAST));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_Q = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity"));

    @Test
    public void testEliminateSorts() {
        String sql = "SELECT quantity, row_number() OVER (ORDER BY quantity) FROM lineitem ORDER BY quantity";
        PlanMatchPattern pattern = PlanMatchPattern.output(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q)));
        this.assertUnitPlan(sql, pattern);
    }

    @Test
    public void testNotEliminateSorts() {
        String sql = "SELECT quantity, row_number() OVER (ORDER BY quantity) FROM lineitem ORDER BY tax";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort(PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q)))));
        this.assertUnitPlan(sql, pattern);
    }

    private void assertUnitPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        TypeAnalyzer typeAnalyzer = new TypeAnalyzer(new SqlParser(), this.getQueryRunner().getMetadata());
        ImmutableList optimizers = ImmutableList.of((Object)new IterativeOptimizer(this.getQueryRunner().getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new DetermineTableScanNodePartitioning(this.getQueryRunner().getMetadata(), this.getQueryRunner().getNodePartitioningManager(), new TaskCountEstimator(() -> 10)))), (Object)new AddExchanges(this.getQueryRunner().getMetadata(), this.getQueryRunner().getTypeOperators(), typeAnalyzer, this.getQueryRunner().getStatsCalculator()));
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }
}

